/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.test.openproject;

import com.xwiki.projectmanagement.test.openproject.FilterBuilderConstraint;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.SuggestInputElement;

public class FilterBuilderFilter
extends BaseElement {
    private final WebElement container;

    public FilterBuilderFilter(WebElement container) {
        this.container = container;
    }

    public String getPropertyName() {
        return this.container.findElement(By.className((String)"proj-manag-constraint-title")).getText();
    }

    public FilterBuilderFilter addConstraint() {
        this.container.findElement(By.className((String)"proj-manag-add-constraint")).click();
        return this;
    }

    public WebElement getConstraint(int index) {
        return this.container.findElement(By.xpath((String)String.format("(div[@class='proj-manag-filter-container'])[%d]", index)));
    }

    public FilterBuilderFilter setOperator(int index, String operator) {
        WebElement operatorElem = this.getConstraint(index).findElement(By.className((String)"proj-manag-constraint-operator"));
        Select select = new Select(operatorElem);
        select.selectByVisibleText(operator);
        return this;
    }

    public WebElement getValueElement(int index) {
        return this.getConstraint(index).findElement(By.cssSelector((String)"input.proj-manag-constraint-value"));
    }

    public FilterBuilderFilter setSuggestValue(int index, String value) {
        WebElement valElem = this.getValueElement(index);
        SuggestInputElement suggest = new SuggestInputElement(valElem);
        this.getDriver().findElementWithoutWaiting(valElem, By.xpath((String)"following-sibling::*[contains(@class, 'selectize-control')][1]")).click();
        suggest.waitForSuggestions().selectByVisibleText(value);
        return this;
    }

    public FilterBuilderFilter setValue(int index, String value) {
        WebElement valElem = this.getValueElement(index);
        valElem.sendKeys(new CharSequence[]{value});
        return this;
    }

    public FilterBuilderFilter setDateValue(int index, String value) {
        throw new NotImplementedException();
    }

    public List<FilterBuilderConstraint> getConstraints() {
        return this.container.findElements(By.className((String)"proj-manag-filter-container")).stream().map(FilterBuilderConstraint::new).collect(Collectors.toList());
    }
}

