/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.macro;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.projectmanagement.internal.macro.AbstractProjectManagementMacro;
import com.xwiki.projectmanagement.macro.ProjectManagementMacroParameters;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConfiguration;
import com.xwiki.projectmanagement.openproject.internal.displayer.StylingSetupManager;
import com.xwiki.projectmanagement.openproject.macro.OpenProjectMacroParameters;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;

@Component
@Singleton
@Named(value="openproject")
public class OpenProjectMacro
extends AbstractProjectManagementMacro<OpenProjectMacroParameters> {
    private static final String CLASS = "class";
    @Inject
    @Named(value="ssrx")
    private SkinExtension ssrx;
    @Inject
    @Named(value="jsx")
    private SkinExtension jsx;
    @Inject
    private OpenProjectConfiguration openProjectConfiguration;
    @Inject
    private Provider<XWikiContext> xContextProvider;
    @Inject
    private CSRFToken csrfToken;
    @Inject
    private ContextualLocalizationManager l10n;
    @Inject
    private StylingSetupManager stylingSetupManager;

    public OpenProjectMacro() {
        super("Open Project", "Retrieve work items from open project.", null, OpenProjectMacroParameters.class);
    }

    public void processParameters(OpenProjectMacroParameters parameters) {
        this.addToSourceParams(parameters, "client", "openproject");
        this.addToSourceParams(parameters, "instance", parameters.getInstance());
        this.addToSourceParams(parameters, "identifier", parameters.getIdentifier());
        this.addToSourceParams(parameters, "translationPrefix", "openproject.");
    }

    public List<Block> execute(OpenProjectMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        this.ssrx.use("openproject/css/propertyStyles.css");
        this.stylingSetupManager.useInstanceStyle(parameters.getInstance());
        this.jsx.use("OpenProject.Code.ViewAction");
        String viewAction = "view";
        XWikiContext xContext = (XWikiContext)this.xContextProvider.get();
        if (xContext.getAction().equals(viewAction)) {
            String connectionName = parameters.getInstance();
            if (xContext.getUserReference() == null || this.openProjectConfiguration.getAccessTokenForConfiguration(connectionName) == null) {
                ArrayList<Object> warning = new ArrayList<Object>();
                warning.add(this.l10n.getTranslation("openproject.oauth.notauthorized.hint").render(new Object[0]));
                if (xContext.getUserReference() != null) {
                    String currentDocumentUrl = xContext.getDoc().getURL(viewAction, xContext);
                    LocalDocumentReference connectionDocumentReference = new LocalDocumentReference(Arrays.asList("OpenProject", "Code"), "RenewOAuthConnection");
                    String redirectUrl = xContext.getWiki().getURL((EntityReference)connectionDocumentReference, viewAction, xContext) + "?connectionName=" + connectionName + "&redirectUrl=" + URLEncoder.encode(currentDocumentUrl, StandardCharsets.UTF_8) + "&token=" + URLEncoder.encode(this.csrfToken.getToken(), StandardCharsets.UTF_8);
                    List<Block> linkContentBlocks = Collections.singletonList(this.l10n.getTranslation("openproject.oauth.notauthorized.link").render(new Object[0]));
                    LinkBlock link = new LinkBlock(linkContentBlocks, new ResourceReference(redirectUrl, ResourceType.URL), false);
                    warning.add(link);
                }
                return Collections.singletonList(new GroupBlock(warning, Collections.singletonMap(CLASS, "box warningmessage")));
            }
        }
        return Collections.singletonList(new GroupBlock(super.execute((ProjectManagementMacroParameters)parameters, content, context), Collections.singletonMap(CLASS, "open-project-macro")));
    }
}

