/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.script;

import com.xwiki.projectmanagement.exception.AuthenticationException;
import com.xwiki.projectmanagement.exception.ProjectManagementException;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConfiguration;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConnection;
import com.xwiki.projectmanagement.openproject.internal.displayer.StylingSetupManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="openproject")
@Singleton
public class OpenProjectScriptService
implements ScriptService {
    @Inject
    private OpenProjectConfiguration openProjectConfiguration;
    @Inject
    private StylingSetupManager stylingSetupManager;
    @Inject
    private ContextualAuthorizationManager authorizationManager;

    public List<Map<String, String>> getConnectionOptions() throws AuthenticationException {
        List<OpenProjectConnection> openProjectConnections = this.openProjectConfiguration.getOpenProjectConnections();
        ArrayList<Map<String, String>> options = new ArrayList<Map<String, String>>();
        for (OpenProjectConnection openProjectConnection : openProjectConnections) {
            HashMap<String, String> option = new HashMap<String, String>();
            option.put("name", openProjectConnection.getConnectionName());
            option.put("value", openProjectConnection.getConnectionName());
            options.add(option);
        }
        return options;
    }

    public boolean isUserAuthorized(String instanceName) {
        String accessToken = this.openProjectConfiguration.getAccessTokenForConfiguration(instanceName);
        return accessToken != null;
    }

    public void generateStyling() throws ProjectManagementException {
        if (!this.authorizationManager.hasAccess(Right.ADMIN)) {
            throw new ProjectManagementException("The styles for the configured Open Project instances should be generated by an admin.");
        }
        this.stylingSetupManager.setupInstanceStyles();
    }
}

