/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.service;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.projectmanagement.exception.ProjectManagementException;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConnection;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component(roles={HandleConnectionsService.class})
@Singleton
public class HandleConnectionsService {
    private static final String CONNECTION_NAME = "connectionName";
    private static final String SERVER_URL = "serverURL";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String OPEN_PROJECT = "OpenProject";
    private static final String CODE = "Code";
    private static final String OPEN_PROJECT_CONNECTION_CLASS = "OpenProjectConnectionClass";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactSerializer;

    public void handleConnection(OpenProjectConnection openProjectConnection, DocumentReference documentReference) throws ProjectManagementException {
        try {
            List result = this.queryManager.createQuery("select obj.name from XWikiDocument doc, BaseObject obj, StringProperty configName where doc.fullName = obj.name and obj.className = :className and obj.id = configName.id.id and configName.id.name = :configFieldName and configName.value = :config and doc.fullName <> :serializedDocRef", "hql").bindValue("className", (Object)String.format("%s.%s.%s", OPEN_PROJECT, CODE, OPEN_PROJECT_CONNECTION_CLASS)).bindValue("configFieldName", (Object)CONNECTION_NAME).bindValue("config", (Object)openProjectConnection.getConnectionName()).bindValue("serializedDocRef", this.compactSerializer.serialize((EntityReference)documentReference, new Object[0])).setWiki(((XWikiContext)this.xcontextProvider.get()).getWikiId()).execute();
            if (!result.isEmpty()) {
                throw new ProjectManagementException(String.format("Connection %s already exists. Use another connection name.", openProjectConnection.getConnectionName()));
            }
            this.handleConnectionObjects(openProjectConnection, documentReference);
        }
        catch (XWikiException | QueryException e) {
            throw new ProjectManagementException("There was a problem while saving the connection", e);
        }
    }

    private void handleConnectionObjects(OpenProjectConnection openProjectConnection, DocumentReference documentReference) throws XWikiException {
        String wikiName = documentReference.getWikiReference().getName();
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument doc = context.getWiki().getDocument(documentReference, context);
        this.setDocMetaData(context, doc);
        DocumentReference configClassRef = new DocumentReference(wikiName, Arrays.asList(OPEN_PROJECT, CODE), OPEN_PROJECT_CONNECTION_CLASS);
        BaseObject configObj = doc.getXObject(configClassRef, true, context);
        configObj.setStringValue(CONNECTION_NAME, openProjectConnection.getConnectionName());
        configObj.setStringValue(SERVER_URL, openProjectConnection.getServerURL());
        configObj.setStringValue(CLIENT_ID, openProjectConnection.getClientId());
        configObj.setStringValue(CLIENT_SECRET, openProjectConnection.getClientSecret());
        DocumentReference oidcClassRef = new DocumentReference(wikiName, Arrays.asList("XWiki", "OIDC"), "ClientConfigurationClass");
        BaseObject oidcObj = doc.getXObject(oidcClassRef, true, context);
        oidcObj.setStringValue("configurationName", openProjectConnection.getConnectionName());
        oidcObj.setStringValue("authorizationEndpoint", openProjectConnection.getServerURL() + "/oauth/authorize");
        oidcObj.setStringValue("tokenEndpoint", openProjectConnection.getServerURL() + "/oauth/token");
        oidcObj.setStringValue(CLIENT_ID, openProjectConnection.getClientId());
        oidcObj.setStringValue(CLIENT_SECRET, openProjectConnection.getClientSecret());
        oidcObj.setStringValue("tokenEndpointMethod", "client_secret_basic");
        oidcObj.setIntValue("skipped", 0);
        oidcObj.setStringValue("scope", "api_v3");
        oidcObj.setStringValue("responseType", "code");
        oidcObj.setIntValue("enableUser", 1);
        oidcObj.setStringValue("tokenStorageScope", "USER");
        context.getWiki().saveDocument(doc, "Saved OpenProject and OIDC config via REST", context);
    }

    private void setDocMetaData(XWikiContext context, XWikiDocument doc) {
        UserReference currentUser = this.userReferenceResolver.resolve((Object)context.getUserReference(), new Object[0]);
        doc.setHidden(Boolean.valueOf(true));
        DocumentAuthors documentAuthors = doc.getAuthors();
        documentAuthors.setCreator(currentUser);
        documentAuthors.setEffectiveMetadataAuthor(currentUser);
        documentAuthors.setContentAuthor(currentUser);
        documentAuthors.setOriginalMetadataAuthor(currentUser);
    }
}

