/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.rest.suggest;

import com.xwiki.projectmanagement.exception.ProjectManagementException;
import com.xwiki.projectmanagement.openproject.OpenProjectApiClient;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConfiguration;
import com.xwiki.projectmanagement.openproject.model.BaseOpenProjectObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;

@Component
@Named(value="com.xwiki.projectmanagement.openproject.internal.rest.suggest.Suggest")
@Singleton
@Path(value="/wikis/{wikiName}/openproject/instance/{instance}/suggest/{suggest}")
public class Suggest
extends XWikiResource {
    private static final String ID = "id";
    private static final String STATUSES = "statuses";
    private static final String PROJECTS = "projects";
    private static final String PRIORITIES = "priorities";
    private static final String NAME = "name";
    private static final String TYPES = "types";
    private static final String USERS = "users";
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String URL = "url";
    private static final String HINT = "hint";
    private static final String ICON = "icon";
    @Inject
    private OpenProjectConfiguration openProjectConfiguration;

    @GET
    @Produces(value={"application/json"})
    public Response getSuggestions(@PathParam(value="wikiName") String wiki, @PathParam(value="instance") String instance, @PathParam(value="suggest") @DefaultValue(value="") String suggest, @QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="pageSize") @DefaultValue(value="10") int pageSize) {
        List<Object> response;
        String lowerSearch = search.toLowerCase();
        OpenProjectApiClient openProjectApiClient = this.openProjectConfiguration.getOpenProjectApiClient(instance);
        if (openProjectApiClient == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            switch (suggest) {
                case "id": {
                    response = this.getIdentifiersSuggestions(openProjectApiClient, lowerSearch, pageSize);
                    break;
                }
                case "priorities": {
                    response = this.getPrioritiesSuggestions(openProjectApiClient);
                    break;
                }
                case "statuses": {
                    response = this.getStatusesSuggestions(openProjectApiClient);
                    break;
                }
                case "projects": {
                    response = this.getProjectsSuggestions(openProjectApiClient, lowerSearch, pageSize);
                    break;
                }
                case "types": {
                    response = this.getTypesSuggestions(openProjectApiClient);
                    break;
                }
                case "users": {
                    response = this.getUsersSuggestions(openProjectApiClient, lowerSearch, pageSize);
                    break;
                }
                default: {
                    response = Collections.emptyList();
                    break;
                }
            }
        }
        catch (ProjectManagementException e) {
            return Response.serverError().entity((Object)e).build();
        }
        return Response.ok(response).build();
    }

    private List<Map<String, String>> getIdentifiersSuggestions(OpenProjectApiClient openProjectApiClient, String searchString, int pageSize) throws ProjectManagementException {
        String filter = this.buildFilter("subject", searchString);
        return openProjectApiClient.getWorkPackages(1, pageSize, filter, "").getItems().stream().map(obj -> this.createSuggestion(String.valueOf(obj.getId()), String.valueOf(obj.getId()), obj.getSelf().getLocation(), obj.getName())).collect(Collectors.toList());
    }

    private List<Map<String, String>> getPrioritiesSuggestions(OpenProjectApiClient openProjectApiClient) throws ProjectManagementException {
        return this.getSuggestions(openProjectApiClient.getPriorities().getItems());
    }

    private List<Map<String, String>> getStatusesSuggestions(OpenProjectApiClient openProjectApiClient) throws ProjectManagementException {
        return this.getSuggestions(openProjectApiClient.getStatuses().getItems());
    }

    private List<Map<String, String>> getProjectsSuggestions(OpenProjectApiClient openProjectApiClient, String searchString, int pageSize) throws ProjectManagementException {
        String filter = this.buildFilter(NAME, searchString);
        return this.getSuggestions(openProjectApiClient.getProjects(1, pageSize, filter).getItems());
    }

    private List<Map<String, String>> getTypesSuggestions(OpenProjectApiClient openProjectApiClient) throws ProjectManagementException {
        return this.getSuggestions(openProjectApiClient.getTypes().getItems());
    }

    private List<Map<String, String>> getUsersSuggestions(OpenProjectApiClient openProjectApiClient, String searchString, int pageSize) throws ProjectManagementException {
        String filter = this.buildFilter(NAME, searchString);
        return this.getSuggestions(openProjectApiClient.getUsers(1, pageSize, filter).getItems());
    }

    private List<Map<String, String>> getSuggestions(List<? extends BaseOpenProjectObject> openProjectObjects) {
        return openProjectObjects.stream().map(obj -> this.createSuggestion(String.valueOf(obj.getId()), obj.getName(), obj.getSelf().getLocation())).collect(Collectors.toList());
    }

    private String buildFilter(String fieldName, String searchValue) {
        if (searchValue.isEmpty()) {
            return "[]";
        }
        return String.format("[{\"%s\":{\"operator\":\"~\",\"values\":[\"%s\"]}}]", fieldName, searchValue);
    }

    private Map<String, String> createSuggestion(String value, String label, String url) {
        return Map.of(VALUE, value, LABEL, label, URL, url);
    }

    private Map<String, String> createSuggestion(String value, String label, String url, String hint) {
        return Map.of(VALUE, value, LABEL, label, URL, url, HINT, hint);
    }
}

