/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.rest.connection;

import com.xpn.xwiki.XWikiException;
import com.xwiki.projectmanagement.exception.ProjectManagementException;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConnection;
import com.xwiki.projectmanagement.openproject.internal.service.HandleConnectionsService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="com.xwiki.projectmanagement.openproject.internal.rest.connection.HandleConnections")
@Path(value="wikis/{wikiName}/spaces/{spaceName: .+}/pages/{pageName}/openproject/configurations")
public class HandleConnections
extends XWikiResource {
    @Inject
    private HandleConnectionsService handleConnectionsService;
    @Inject
    private AuthorizationManager authorizationManager;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createConnection(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, OpenProjectConnection openProjectConnection) {
        return this.processConnection(wikiName, spaceName, pageName, openProjectConnection, true);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateConnection(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, OpenProjectConnection openProjectConnection) {
        return this.processConnection(wikiName, spaceName, pageName, openProjectConnection, false);
    }

    private void checkAccessRights() throws XWikiException {
        DocumentReference currentUserRef = this.getXWikiContext().getUserReference();
        if (!this.authorizationManager.hasAccess(Right.ADMIN, currentUserRef, (EntityReference)this.getXWikiContext().getWikiReference())) {
            throw new XWikiException(9, 9001, "You need Admin rights to perform this operation.");
        }
    }

    private Response processConnection(String wikiName, String spaceName, String pageName, OpenProjectConnection openProjectConnection, boolean isNewConnection) {
        try {
            this.checkAccessRights();
            DocumentReference documentReference = new DocumentReference(pageName, this.getSpaceReference(spaceName, wikiName));
            this.handleConnectionsService.handleConnection(openProjectConnection, documentReference);
            if (isNewConnection) {
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (XWikiException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
        catch (ProjectManagementException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (XWikiRestException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

