/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.rest;

import com.xwiki.projectmanagement.exception.ProjectManagementException;
import com.xwiki.projectmanagement.exception.WorkItemNotFoundException;
import com.xwiki.projectmanagement.exception.WorkItemRetrievalException;
import com.xwiki.projectmanagement.openproject.OpenProjectApiClient;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConfiguration;
import com.xwiki.projectmanagement.openproject.model.UserAvatar;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.bridge.SkinAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;

@Component
@Named(value="com.xwiki.projectmanagement.openproject.internal.rest.OpenProjectAvatarResource")
@Path(value="/wikis/{wikiName}/openproject/instance/{instance}/users/{id}/avatar")
@Singleton
public class OpenProjectAvatarResource
extends XWikiResource {
    @Inject
    private OpenProjectConfiguration openProjectConfiguration;
    @Inject
    private SkinAccessBridge skinAccessBridge;

    @GET
    @Produces(value={"image/jpeg"})
    public Response getAvatar(@PathParam(value="wikiName") String wiki, @PathParam(value="instance") String instance, @PathParam(value="id") String userId) throws URISyntaxException {
        OpenProjectApiClient openProjectApiClient = this.openProjectConfiguration.getOpenProjectApiClient(instance);
        if (openProjectApiClient == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            UserAvatar userAvatar = openProjectApiClient.getUserAvatar(userId);
            return Response.ok((Object)userAvatar.getStreamingOutput(), (String)userAvatar.getContentType()).build();
        }
        catch (WorkItemNotFoundException userAvatar) {
        }
        catch (WorkItemRetrievalException e) {
            this.getLogger().warn("Failed to retrive the avatar for user [{}] with the following open project error: [{}].", (Object)userId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        catch (ProjectManagementException e) {
            this.getLogger().error("Failed to retrive the avatar for user [{}] due to network or server issues.", (Object)userId, (Object)e);
        }
        return Response.seeOther((URI)new URI(this.skinAccessBridge.getSkinFile("icons/xwiki/noavatar.png"))).build();
    }
}

