/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xwiki.projectmanagement.internal.macro.ProjectManagementAsyncRenderer;
import com.xwiki.projectmanagement.macro.ProjectManagementMacroParameters;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.JobException;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.AsyncRenderer;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.AsyncRendererExecutor;
import org.xwiki.rendering.async.internal.AsyncRendererExecutorResponse;
import org.xwiki.rendering.async.internal.AsyncRendererResult;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rest.XWikiResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="com.xwiki.projectmanagement.openproject.internal.rest.AsyncMacroCallResource")
@Path(value="/wikis/{wikiName}/openproject/async/displayer/{displayer}/instance/{instance}/workpackage/{identifier}")
public class AsyncMacroCallResource
extends XWikiResource {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private AsyncRendererExecutor asyncRendererExecutor;
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    @GET
    @Produces(value={"text/plain"})
    public Response getAsyncCall(@PathParam(value="wikiName") String wiki, @PathParam(value="displayer") String displayer, @PathParam(value="instance") String instance, @PathParam(value="identifier") String workPackageId) {
        if (!this.authorizationManager.hasAccess(Right.VIEW)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            AsyncRendererConfiguration configuration = new AsyncRendererConfiguration();
            configuration.setPlaceHolderForced(true);
            ProjectManagementAsyncRenderer asyncRenderer = this.getAsyncRenderer(displayer, instance, workPackageId, configuration);
            AsyncRendererExecutorResponse response = this.asyncRendererExecutor.render((AsyncRenderer)asyncRenderer, configuration);
            AsyncRendererResult result = response.getStatus().getResult();
            if (result != null && !configuration.isPlaceHolderForced()) {
                return Response.ok((Object)result.getResult()).build();
            }
            String placeholder = String.format("<div class=\"xwiki-async\" data-xwiki-async-id=\"%s\" data-xwiki-async-client-id=\"%s\"></div>", response.getJobIdHTTPPath(), response.getAsyncClientId());
            return Response.ok((Object)placeholder).build();
        }
        catch (JsonProcessingException | JobException | RenderingException e) {
            return Response.serverError().build();
        }
        catch (ComponentLookupException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    private ProjectManagementAsyncRenderer getAsyncRenderer(String displayer, String instance, String workPackageId, AsyncRendererConfiguration configuration) throws ComponentLookupException, JsonProcessingException {
        ProjectManagementAsyncRenderer asyncRenderer = (ProjectManagementAsyncRenderer)this.componentManager.getInstance(ProjectManagementAsyncRenderer.class);
        configuration.setContextEntries(Set.of("user", "wiki", "action", "locale"));
        if (displayer == null || displayer.isEmpty()) {
            throw new ComponentLookupException("The displayer hint is not present.");
        }
        Macro displayerMacro = (Macro)this.componentManager.getInstance(Macro.class, displayer);
        ProjectManagementMacroParameters parameters = new ProjectManagementMacroParameters();
        parameters.setSourceParameters(String.format("instance=%s&client=%s&translationPrefix=%s", instance, "openproject", "openproject."));
        LiveDataConfiguration liveDataConfiguration = new LiveDataConfiguration();
        liveDataConfiguration.setQuery(new LiveDataQuery());
        liveDataConfiguration.getQuery().setFilters(Arrays.asList(new LiveDataQuery.Filter("identifier", "=", (Object)workPackageId)));
        String content = this.jsonMapper.writeValueAsString((Object)liveDataConfiguration);
        MacroTransformationContext context = new MacroTransformationContext();
        asyncRenderer.initialize(displayerMacro, parameters, content, context);
        return asyncRenderer;
    }
}

