/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.processing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xwiki.projectmanagement.exception.ProjectManagementException;
import com.xwiki.projectmanagement.openproject.internal.processing.OpenProjectMapper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.xwiki.livedata.LiveDataQuery;

public final class OpenProjectSortingHandler {
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private static final String FAILURE_MESSAGE = "Failed to convert Livedata sorting";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private OpenProjectSortingHandler() {
    }

    public static String convertSorting(List<LiveDataQuery.SortEntry> sortEntries) throws ProjectManagementException {
        List convertedSortEntries = sortEntries.stream().map(sortEntry -> List.of(OpenProjectMapper.mapLivedataProperty(sortEntry.getProperty()), sortEntry.isDescending() ? DESC : ASC)).collect(Collectors.toList());
        try {
            return MAPPER.writeValueAsString(convertedSortEntries);
        }
        catch (JsonProcessingException e) {
            throw new ProjectManagementException(FAILURE_MESSAGE, (Throwable)e);
        }
    }

    public static String mergeSortEntries(List<LiveDataQuery.SortEntry> sortEntries, String sortByEntries) throws ProjectManagementException {
        LinkedHashMap sortMap = new LinkedHashMap();
        sortEntries.forEach(entry -> sortMap.put(OpenProjectMapper.mapLivedataProperty(entry.getProperty()), entry.isDescending() ? DESC : ASC));
        if (sortByEntries != null && !sortByEntries.isEmpty()) {
            Arrays.stream(sortByEntries.split(",")).forEach(entry -> {
                String[] splitEntry = entry.split(":");
                if (!sortMap.containsKey(splitEntry[0])) {
                    sortMap.put(OpenProjectMapper.mapLivedataProperty(splitEntry[0]), splitEntry[1]);
                }
            });
        }
        List listOfEntries = sortMap.entrySet().stream().map(entry -> List.of((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        try {
            return MAPPER.writeValueAsString(listOfEntries);
        }
        catch (JsonProcessingException e) {
            throw new ProjectManagementException(FAILURE_MESSAGE, (Throwable)e);
        }
    }
}

