/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.processing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xwiki.projectmanagement.exception.ProjectManagementException;
import com.xwiki.projectmanagement.openproject.internal.processing.OpenProjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.xwiki.livedata.LiveDataQuery;

public final class OpenProjectFilterHandler {
    private static final String OPERATOR = "operator";
    private static final String VALUES = "values";
    private static final String FAILURE_MESSAGE = "Failed to convert Livedata filters";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Set<String> PROPERTIES_DATE = Set.of("startDate", "dueDate", "creationDate", "updateDate");
    private static final Set<String> OPERATORS_EMPTY_VALS = Set.of("t", "w", "*", "!*", String.valueOf('o'), "c");

    private OpenProjectFilterHandler() {
    }

    public static String convertFilters(List<LiveDataQuery.Filter> filters) throws ProjectManagementException {
        List<Map<String, Object>> convertedFilters = OpenProjectFilterHandler.getConvertedFilters(filters);
        try {
            return MAPPER.writeValueAsString(convertedFilters);
        }
        catch (JsonProcessingException e) {
            throw new ProjectManagementException(FAILURE_MESSAGE, (Throwable)e);
        }
    }

    public static String mergeFilters(List<LiveDataQuery.Filter> filters, JsonNode filtersNode) throws ProjectManagementException {
        HashMap<String, Object> mergedFilters = new HashMap<String, Object>();
        for (LiveDataQuery.Filter filter : filters) {
            List<LiveDataQuery.Constraint> validConstraints = OpenProjectFilterHandler.getValidConstraints(filter);
            if (validConstraints.isEmpty()) continue;
            Map<String, List<String>> filterConstraints = OpenProjectFilterHandler.handleFilterConstraints(filter.getProperty(), validConstraints);
            String filterName = OpenProjectMapper.mapLivedataProperty(filter.getProperty());
            mergedFilters.put(filterName, filterConstraints);
        }
        Map<String, Object> convertedFiltersFromNode = OpenProjectFilterHandler.handleFilterNode(filtersNode);
        OpenProjectFilterHandler.mergeFiltersMaps(mergedFilters, convertedFiltersFromNode);
        return OpenProjectFilterHandler.convertMapOfFiltersToString(mergedFilters);
    }

    private static Map<String, Object> handleFilterNode(JsonNode filterNode) {
        if (filterNode == null || filterNode.isEmpty()) {
            return Collections.emptyMap();
        }
        List filtersList = (List)MAPPER.convertValue((Object)filterNode, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        HashMap<String, Object> convertedFilters = new HashMap<String, Object>();
        for (Map filter : filtersList) {
            String name = (String)filter.get("n");
            String operator = (String)filter.get("o");
            List values = (List)filter.get("v");
            convertedFilters.put(name, Map.of(operator, values));
        }
        return convertedFilters;
    }

    private static List<Map<String, Object>> getConvertedFilters(List<LiveDataQuery.Filter> filters) {
        ArrayList<Map<String, Object>> convertedFilters = new ArrayList<Map<String, Object>>();
        for (LiveDataQuery.Filter filter : filters) {
            List<LiveDataQuery.Constraint> validConstraints = OpenProjectFilterHandler.getValidConstraints(filter);
            if (validConstraints.isEmpty()) continue;
            Map<String, List<String>> filterConstraints = OpenProjectFilterHandler.handleFilterConstraints(filter.getProperty(), validConstraints);
            filterConstraints.forEach((key, value) -> {
                String filterName = OpenProjectMapper.mapLivedataProperty(filter.getProperty());
                convertedFilters.add(Map.of(filterName, Map.of(OPERATOR, key, VALUES, value)));
            });
        }
        return convertedFilters;
    }

    private static List<String> convertToOpenProjectValue(String propertyName, String values) {
        if (!PROPERTIES_DATE.contains(propertyName)) {
            return Collections.singletonList(values);
        }
        String[] parts = values.split("/");
        if (parts.length > 1) {
            return Arrays.asList(parts[0], parts[1]);
        }
        return Collections.singletonList(values);
    }

    private static List<LiveDataQuery.Constraint> getValidConstraints(LiveDataQuery.Filter filter) {
        return filter.getConstraints().stream().filter(constraint -> {
            String constraintValue = (String)constraint.getValue();
            if (OPERATORS_EMPTY_VALS.contains(constraint.getOperator())) {
                return true;
            }
            return constraintValue != null && !constraintValue.isEmpty();
        }).collect(Collectors.toList());
    }

    private static Map<String, List<String>> handleFilterConstraints(String propertyName, List<LiveDataQuery.Constraint> filterConstraints) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (LiveDataQuery.Constraint constraint : filterConstraints) {
            String operatorValue = OpenProjectMapper.mapLivedataOperator(constraint.getOperator());
            List<String> values = OpenProjectFilterHandler.convertToOpenProjectValue(propertyName, (String)constraint.getValue());
            if (result.containsKey(operatorValue)) {
                List currentValues = (List)result.get(operatorValue);
                currentValues.addAll(values);
                continue;
            }
            result.put(operatorValue, new ArrayList<String>(values));
        }
        return result;
    }

    private static String convertMapOfFiltersToString(Map<String, Object> filters) throws ProjectManagementException {
        ArrayList convertedFilters = new ArrayList();
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            Map constraints = (Map)entry.getValue();
            constraints.forEach((key, value) -> convertedFilters.add(Map.of((String)entry.getKey(), Map.of(OPERATOR, key, VALUES, value))));
        }
        try {
            return MAPPER.writeValueAsString(convertedFilters);
        }
        catch (JsonProcessingException e) {
            throw new ProjectManagementException(FAILURE_MESSAGE, (Throwable)e);
        }
    }

    private static void mergeFiltersMaps(Map<String, Object> firstMap, Map<String, Object> secondMap) {
        for (Map.Entry<String, Object> entry : secondMap.entrySet()) {
            if (firstMap.containsKey(entry.getKey())) {
                Map firstFilter = (Map)firstMap.get(entry.getKey());
                Map secondFilter = (Map)entry.getValue();
                secondFilter.forEach((key, value) -> {
                    if (firstFilter.containsKey(key)) {
                        List firstFilterValues = (List)firstFilter.get(key);
                        List secondFilterValues = (List)value;
                        for (String filterValue : secondFilterValues) {
                            if (firstFilterValues.contains(filterValue)) continue;
                            firstFilterValues.add(filterValue);
                        }
                    } else {
                        firstFilter.put(key, value);
                    }
                });
                continue;
            }
            firstMap.put(entry.getKey(), entry.getValue());
        }
    }
}

