/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.livedata;

import com.xpn.xwiki.XWikiContext;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataPropertyDescriptor;

@Component
@Named(value="openproject")
@Singleton
public class OpenProjectLivedataConfigurationResolver
implements LiveDataConfigurationResolver<LiveDataConfiguration> {
    private static final String FILTER_KEY_SEARCHURL = "searchURL";
    private static final String SOURCE_PARAMS_INSTANCE = "instance";
    @Inject
    private LiveDataConfigurationResolver<String> stringLiveDataConfigResolver;
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xWikiContextProvider;
    private String defaultConfigJSON;

    public LiveDataConfiguration resolve(LiveDataConfiguration input) throws LiveDataException {
        try {
            if (this.defaultConfigJSON == null || this.defaultConfigJSON.isEmpty()) {
                InputStream defaultConfigInputStream = this.getClass().getResourceAsStream("/openProjectLiveDataConfiguration.json");
                this.defaultConfigJSON = defaultConfigInputStream == null ? "" : IOUtils.toString((InputStream)defaultConfigInputStream, (String)"UTF-8");
            }
            LiveDataConfiguration configuration = this.stringLiveDataConfigResolver.resolve((Object)this.defaultConfigJSON);
            this.maybeUpdateSearchURL(configuration, input);
            return configuration;
        }
        catch (IOException | LiveDataException e) {
            this.logger.error("Could not read the livedata configuration of the Open Project client.", e);
            return null;
        }
    }

    private void maybeUpdateSearchURL(LiveDataConfiguration configuration, LiveDataConfiguration input) {
        if (configuration.getMeta() == null || configuration.getMeta().getPropertyDescriptors() == null) {
            return;
        }
        String instance = this.getInstance(input);
        String wiki = this.getWiki();
        for (LiveDataPropertyDescriptor propertyDescriptor : configuration.getMeta().getPropertyDescriptors()) {
            String searchURL;
            if (propertyDescriptor.getFilter() == null || !"list".equals(propertyDescriptor.getFilter().getId()) || (searchURL = (String)propertyDescriptor.getFilter().getParameters().get(FILTER_KEY_SEARCHURL)) == null || searchURL.isEmpty()) continue;
            searchURL = searchURL.replace("{wikiName}", wiki);
            if (instance != null && !instance.isEmpty()) {
                searchURL = searchURL.replace("{instance}", instance);
            }
            propertyDescriptor.getFilter().getParameters().put(FILTER_KEY_SEARCHURL, searchURL);
        }
    }

    private String getInstance(LiveDataConfiguration input) {
        if (input.getQuery() != null && input.getQuery().getSource() != null && input.getQuery().getSource().getParameters() != null) {
            return (String)input.getQuery().getSource().getParameters().get(SOURCE_PARAMS_INSTANCE);
        }
        return null;
    }

    private String getWiki() {
        String wiki = "xwiki";
        XWikiContext context = (XWikiContext)this.xWikiContextProvider.get();
        if (context == null) {
            return wiki;
        }
        return context.getWikiId() == null || context.getWikiId().isEmpty() ? wiki : context.getWikiId();
    }
}

