/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.listener;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.plugin.scheduler.JobState;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="com.xwiki.projectmanagement.openproject.internal.listener.StyleSetupJobSchedulerListener")
public class StyleSetupJobSchedulerListener
extends AbstractEventListener {
    private static final String OPEN_PROJECT = "OpenProject";
    private static final EntityReference CLASS_OPEN_PROJECT = BaseObjectReference.any((String)"OpenProject.Code.OpenProjectConnectionClass");
    private static final EntityReference DOC_SCHEDULER_JOB = new LocalDocumentReference(Arrays.asList("OpenProject", "Code"), "StylingSetupJob");
    private static final String OP_API_ID = "com.xwiki.projectmanagement:project-management-openproject-api";
    private static final String PLUGIN_SCHEDULER = "scheduler";
    private static final String JOB_CONTEXT_USER = "contextUser";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public StyleSetupJobSchedulerListener() {
        super(StyleSetupJobSchedulerListener.class.getName(), Arrays.asList(new XObjectUpdatedEvent(CLASS_OPEN_PROJECT)));
    }

    public void onEvent(Event event, Object source, Object data) {
        this.maybeChangeJobUserAndReschedule((XWikiDocument)source, (XWikiContext)data);
    }

    private void maybeChangeJobUserAndReschedule(XWikiDocument source, XWikiContext data) {
        SchedulerPlugin scheduler = (SchedulerPlugin)data.getWiki().getPluginManager().getPlugin(PLUGIN_SCHEDULER);
        try {
            XWikiDocument jobDoc = data.getWiki().getDocument(DOC_SCHEDULER_JOB, data);
            BaseObject job = jobDoc.getXObject(SchedulerPlugin.XWIKI_JOB_CLASSREFERENCE);
            JobState jobState = scheduler.getJobStatus(job, data);
            String currentUser = (String)this.serializer.serialize((EntityReference)data.getUserReference(), new Object[0]);
            if (currentUser.equals(job.getStringValue(JOB_CONTEXT_USER))) {
                return;
            }
            boolean shouldSchedule = false;
            if (jobState.getQuartzState().equals((Object)Trigger.TriggerState.NORMAL)) {
                shouldSchedule = true;
                scheduler.unscheduleJob(job, data);
            } else if (jobState.getQuartzState().equals((Object)Trigger.TriggerState.NONE)) {
                shouldSchedule = true;
            }
            if (shouldSchedule) {
                job.setStringValue(JOB_CONTEXT_USER, currentUser);
                data.getWiki().saveDocument(jobDoc, String.format("Updated context user to [%s].", data.getUserReference()), data);
                scheduler.scheduleJob(job, data);
            }
        }
        catch (XWikiException | SchedulerException e) {
            this.logger.warn("Failed to set the context user [{}] for the job [{}] and reschedule it. Cause: [{}].", new Object[]{data.getUserReference(), DOC_SCHEDULER_JOB, ExceptionUtils.getRootCauseMessage((Throwable)e)});
        }
    }
}

