/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.displayer.property;

import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayer;
import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

public class UserPropertyDisplayer
implements WorkItemPropertyDisplayer {
    private WorkItemPropertyDisplayerManager displayerManager;

    public UserPropertyDisplayer(WorkItemPropertyDisplayerManager displayerManager) {
        this.displayerManager = displayerManager;
    }

    public List<Block> display(Object property, Map<String, Object> params) {
        List blocks = property instanceof Collection ? this.displayerManager.displayProperty("list", property, params) : this.displayerManager.displayProperty(property.getClass().getName(), property, params);
        if (params.isEmpty() || !params.containsKey("instance") || !params.containsKey("wiki")) {
            return blocks;
        }
        XDOM xdom = new XDOM(blocks);
        List userLinkBlocks = xdom.getBlocks((BlockMatcher)new ClassBlockMatcher(LinkBlock.class), Block.Axes.DESCENDANT_OR_SELF);
        if (userLinkBlocks.isEmpty()) {
            return blocks;
        }
        ArrayList<Block> linksWithAvatars = new ArrayList<Block>();
        for (Block userLinkBlock : userLinkBlocks) {
            GroupBlock group = new GroupBlock();
            String userAvatarLink = ((LinkBlock)userLinkBlock).getReference().getReference();
            String userAvatarPath = userAvatarLink.substring(userAvatarLink.indexOf("/users/"));
            String xwikiUserAvatarLink = String.format("/xwiki/rest/wikis/%s/openproject/instance/%s%s/avatar", params.get("wiki"), params.get("instance"), userAvatarPath);
            ImageBlock imageBlock = new ImageBlock(new ResourceReference(xwikiUserAvatarLink, ResourceType.URL), true, Map.of("alt", "User avatar", "class", "user-avatar"));
            group.addChild((Block)new FormatBlock(Collections.singletonList(imageBlock), Format.NONE, Collections.singletonMap("class", "open-project-user-avatar user")));
            group.addChild((Block)new FormatBlock(Collections.singletonList(userLinkBlock), Format.NONE, Collections.singletonMap("class", "open-project-user-link")));
            linksWithAvatars.add((Block)group);
        }
        return linksWithAvatars;
    }
}

