/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.displayer.property;

import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayer;
import com.xwiki.projectmanagement.openproject.internal.displayer.IdGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;

public class TypePropertyDisplayer
implements WorkItemPropertyDisplayer {
    private final Parser plainTextParser;
    private final Logger logger = LoggerFactory.getLogger(TypePropertyDisplayer.class);

    public TypePropertyDisplayer(Parser parser) {
        this.plainTextParser = parser;
    }

    public List<Block> display(Object property, Map<String, Object> params) {
        if (property == null) {
            return Collections.emptyList();
        }
        try {
            List statusBlocks;
            Object lowerCaseProp = IdGenerator.generate(property.toString());
            String instance = params.getOrDefault("instance", "").toString();
            if (!instance.isEmpty()) {
                lowerCaseProp = (String)lowerCaseProp + "-" + IdGenerator.generate(instance);
            }
            if (!(statusBlocks = this.plainTextParser.parse((Reader)new StringReader(property.toString())).getChildren()).isEmpty() && statusBlocks.get(0) instanceof ParagraphBlock) {
                statusBlocks = ((Block)statusBlocks.get(0)).getChildren();
            }
            return Collections.singletonList(new FormatBlock(statusBlocks, Format.NONE, Map.of("class", "openproject-property-type openproject-property-type-" + (String)lowerCaseProp)));
        }
        catch (ParseException e) {
            this.logger.warn("Failed to parse the work package property with value [{}]. Cause: [{}].", property, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Collections.emptyList();
        }
    }
}

