/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.displayer;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.projectmanagement.ProjectManagementClientExecutionContext;
import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayer;
import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayerManager;
import com.xwiki.projectmanagement.internal.displayer.property.StringPropertyDisplayer;
import com.xwiki.projectmanagement.openproject.internal.displayer.property.StatusPropertyDisplayer;
import com.xwiki.projectmanagement.openproject.internal.displayer.property.TypePropertyDisplayer;
import com.xwiki.projectmanagement.openproject.internal.displayer.property.UserPropertyDisplayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.parser.Parser;

@Singleton
@Component
@Named(value="openproject")
public class OpenProjectDisplayerManager
implements WorkItemPropertyDisplayerManager,
Initializable {
    public static final String KEY_INSTANCE = "instance";
    public static final String KEY_WIKI = "wiki";
    @Inject
    private WorkItemPropertyDisplayerManager defaultDisplayerManager;
    @Inject
    private ProjectManagementClientExecutionContext executionContext;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    @Named(value="html/5.0")
    private Parser htmlParser;
    @Inject
    private Provider<XWikiContext> contextProvider;
    private final Map<String, WorkItemPropertyDisplayer> registeredDisplayers = new HashMap<String, WorkItemPropertyDisplayer>();

    public void initialize() throws InitializationException {
        this.registeredDisplayers.put("type", new TypePropertyDisplayer(this.plainTextParser));
        this.registeredDisplayers.put("status", new StatusPropertyDisplayer(this.plainTextParser));
        this.registeredDisplayers.put("description", (WorkItemPropertyDisplayer)new StringPropertyDisplayer(this.htmlParser));
        UserPropertyDisplayer userPropertyDisplayer = new UserPropertyDisplayer(this);
        this.registeredDisplayers.put("reporter", userPropertyDisplayer);
        this.registeredDisplayers.put("assignees", userPropertyDisplayer);
        this.registeredDisplayers.put("creator", userPropertyDisplayer);
    }

    public List<Block> displayProperty(String propertyName, Object propertyValue, Map<String, Object> parameters) {
        if (this.registeredDisplayers.containsKey(propertyName)) {
            Map<String, Object> newParams = parameters;
            if (!parameters.containsKey(KEY_INSTANCE) || !parameters.containsKey(KEY_WIKI)) {
                newParams = new HashMap<String, Object>(newParams);
                newParams.putIfAbsent(KEY_INSTANCE, this.executionContext.getContext().getOrDefault(KEY_INSTANCE, ""));
                newParams.putIfAbsent(KEY_WIKI, ((XWikiContext)this.contextProvider.get()).getWikiId());
            }
            return this.registeredDisplayers.get(propertyName).display(propertyValue, newParams);
        }
        return this.defaultDisplayerManager.displayProperty(propertyName, propertyValue, parameters);
    }

    public WorkItemPropertyDisplayer getDisplayerForProperty(String property) {
        WorkItemPropertyDisplayer propertyDisplayer = this.registeredDisplayers.get(property);
        if (propertyDisplayer == null) {
            return this.defaultDisplayerManager.getDisplayerForProperty(property);
        }
        return propertyDisplayer;
    }
}

