/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.config;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.internal.AbstractDocumentConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Named(value="openproject")
@Singleton
public class OpenProjectDocumentConfigurationSource
extends AbstractDocumentConfigurationSource {
    private static final String OPEN_PROJECT_CONNECTION_CLASS = "OpenProjectConnectionClass";
    private static final String OPEN_PROJECT = "OpenProject";
    private static final String CODE = "Code";
    private static final String OPEN_PROJECT_CONFIGURATIONS = "OpenProjectConfigurations";
    private static final LocalDocumentReference CLASS_REFERENCE = new LocalDocumentReference(Arrays.asList("OpenProject", "Code"), "OpenProjectConnectionClass");
    private static final LocalDocumentReference DOC_REFERENCE = new LocalDocumentReference(Arrays.asList("OpenProject", "Code", "OpenProjectConfigurations"), "OpenProjectConnectionClass");
    @Inject
    private QueryManager queryManager;
    @Inject
    private EntityReferenceResolver<String> referenceResolver;

    protected DocumentReference getDocumentReference() {
        return new DocumentReference(DOC_REFERENCE, this.getCurrentWikiReference());
    }

    protected LocalDocumentReference getClassReference() {
        return CLASS_REFERENCE;
    }

    protected String getCacheId() {
        return "configuration.document.openproject";
    }

    protected Object getBaseProperty(String propertyName, boolean text) throws XWikiException {
        if (!propertyName.equals("openprojectConnections")) {
            return super.getBaseProperty(propertyName, text);
        }
        XWikiContext xContext = (XWikiContext)this.xcontextProvider.get();
        ArrayList<OpenProjectConnection> objects = new ArrayList<OpenProjectConnection>();
        try {
            String query = String.format("from doc.object(%s.%s.%s) as cfg", OPEN_PROJECT, CODE, OPEN_PROJECT_CONNECTION_CLASS);
            List results = this.queryManager.createQuery(query, "xwql").setWiki(xContext.getWikiId()).execute();
            for (String docName : results) {
                EntityReference entityReference = this.referenceResolver.resolve((Object)docName, EntityType.DOCUMENT, new Object[]{this.getCurrentWikiReference()});
                DocumentReference docRef = new DocumentReference(entityReference);
                XWikiDocument xwikiDocument = xContext.getWiki().getDocument(docRef, xContext);
                BaseObject baseObject = xwikiDocument.getXObject((EntityReference)this.getClassReference());
                if (baseObject == null) continue;
                String connectionName = baseObject.getStringValue("connectionName");
                String serverURL = baseObject.getStringValue("serverURL");
                String clientId = baseObject.getStringValue("clientId");
                String clientSecret = baseObject.getStringValue("clientSecret");
                objects.add(new OpenProjectConnection(connectionName, serverURL, clientId, clientSecret));
            }
            return objects;
        }
        catch (QueryException e) {
            throw new XWikiException("Query creation error", (Throwable)e);
        }
    }
}

