/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal.config;

import com.xwiki.projectmanagement.exception.AuthenticationException;
import com.xwiki.projectmanagement.model.PaginatedResult;
import com.xwiki.projectmanagement.openproject.OpenProjectApiClient;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConfiguration;
import com.xwiki.projectmanagement.openproject.config.OpenProjectConnection;
import com.xwiki.projectmanagement.openproject.internal.CachingOpenProjectApiClient;
import com.xwiki.projectmanagement.openproject.internal.DefaultOpenProjectApiClient;
import com.xwiki.projectmanagement.openproject.model.BaseOpenProjectObject;
import java.net.http.HttpClient;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.contrib.oidc.OAuth2ClientScriptService;
import org.xwiki.contrib.oidc.OAuth2Exception;
import org.xwiki.script.service.ScriptService;

@Component
@Singleton
public class DefaultOpenProjectConfiguration
implements OpenProjectConfiguration,
Initializable,
Disposable {
    private static final String OAUTH_COMPONENT_NAME = "oauth2client";
    @Inject
    @Named(value="openproject")
    private ConfigurationSource openProjectConfiguration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private Logger logger;
    private Cache<PaginatedResult<? extends BaseOpenProjectObject>> cache;

    public void initialize() throws InitializationException {
        CacheConfiguration cacheConfig = new CacheConfiguration();
        cacheConfig.setConfigurationId("projectmanagement.openproject");
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setLifespan(7200);
        lru.setMaxEntries(1000);
        cacheConfig.put((Object)"eviction", (Object)lru);
        try {
            this.cache = this.cacheManager.createNewCache(cacheConfig);
        }
        catch (Exception e) {
            if (this.cache != null) {
                this.cache.dispose();
            }
            throw new InitializationException("Failed to create the Open Project client cache.", (Throwable)e);
        }
    }

    @Override
    public List<OpenProjectConnection> getOpenProjectConnections() {
        return (List)this.openProjectConfiguration.getProperty("openprojectConnections");
    }

    @Override
    public OpenProjectConnection getConnection(String connectionName) {
        List<OpenProjectConnection> connections = this.getOpenProjectConnections();
        return connections.stream().filter(connection -> connection.getConnectionName().equals(connectionName)).findFirst().orElse(null);
    }

    @Override
    public String getAccessTokenForConfiguration(String connectionName) {
        String accessToken = null;
        try {
            OAuth2ClientScriptService oauth2Client = (OAuth2ClientScriptService)this.componentManager.getInstance(ScriptService.class, OAUTH_COMPONENT_NAME);
            accessToken = oauth2Client.getAccessToken(connectionName);
        }
        catch (ComponentLookupException | OAuth2Exception e) {
            this.logger.warn(String.format("Failed to retrieve the access token for instance [%s]. Cause: [%s].", connectionName, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
        return accessToken;
    }

    @Override
    public void createNewToken(String connectionName, String redirectUrl) throws AuthenticationException {
        try {
            OAuth2ClientScriptService oauth2Client = (OAuth2ClientScriptService)this.componentManager.getInstance(ScriptService.class, OAUTH_COMPONENT_NAME);
            oauth2Client.authorize(connectionName, redirectUrl);
        }
        catch (ComponentLookupException | OAuth2Exception e) {
            throw new AuthenticationException(String.format("Failed to establish the OAuth2 connection for instance [%s]", connectionName), e);
        }
    }

    @Override
    public OpenProjectApiClient getOpenProjectApiClient(String connectionName) {
        OpenProjectConnection connection = this.getConnection(connectionName);
        String accessToken = this.getAccessTokenForConfiguration(connectionName);
        if (connection == null || StringUtils.isEmpty((CharSequence)accessToken)) {
            this.logger.warn(String.format("No client for connection [%s] could be created because the configuration doesn't exist or the access token for the current user is not set.", connectionName));
            return null;
        }
        DefaultOpenProjectApiClient openProjectApiClient = new DefaultOpenProjectApiClient(connection.getServerURL(), accessToken, HttpClient.newHttpClient());
        return new CachingOpenProjectApiClient(openProjectApiClient, connection.getClientId(), this.cache);
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.cache != null) {
            this.cache.dispose();
        }
    }

    @Override
    public void cleanCache() {
        if (this.cache != null) {
            this.cache.removeAll();
        }
    }
}

