/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal;

import com.xwiki.projectmanagement.model.Linkable;
import com.xwiki.projectmanagement.model.PaginatedResult;
import com.xwiki.projectmanagement.model.WorkItem;
import com.xwiki.projectmanagement.openproject.model.WorkPackage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class OpenProjectConverters {
    private OpenProjectConverters() {
    }

    public static WorkItem convertWorkPackageToWorkItem(WorkPackage workPackage) {
        WorkItem workItem = new WorkItem();
        OpenProjectConverters.setBasicInfo(workItem, workPackage);
        OpenProjectConverters.setDates(workItem, workPackage);
        OpenProjectConverters.setLinks(workItem, workPackage);
        OpenProjectConverters.setAssignments(workItem, workPackage);
        OpenProjectConverters.setProjectAndPriority(workItem, workPackage);
        return workItem;
    }

    private static void setBasicInfo(WorkItem workItem, WorkPackage workPackage) {
        if (workPackage.getDescription() != null) {
            workItem.setDescription(workPackage.getDescription());
        }
        if (workPackage.getPercentageDone() != null) {
            workItem.setProgress(workPackage.getPercentageDone());
        }
        if (workPackage.getTypeOfWorkPackage() != null) {
            workItem.setType(workPackage.getTypeOfWorkPackage().getValue());
        }
        if (workPackage.getStatus() != null) {
            workItem.setStatus(workPackage.getStatus().getValue());
        }
    }

    private static void setDates(WorkItem workItem, WorkPackage workPackage) {
        if (workPackage.getStartDate() != null) {
            workItem.setStartDate(workPackage.getStartDate());
        }
        if (workPackage.getDueDate() != null) {
            workItem.setDueDate(workPackage.getDueDate());
        }
        if (workPackage.getCreatedAt() != null) {
            workItem.setCreationDate(workPackage.getCreatedAt());
        }
        if (workPackage.getUpdatedAt() != null) {
            workItem.setUpdateDate(workPackage.getUpdatedAt());
        }
    }

    private static void setLinks(WorkItem workItem, WorkPackage workPackage) {
        if (workPackage.getSelf() != null) {
            workItem.setIdentifier(new Linkable(String.valueOf(workPackage.getId()), workPackage.getSelf().getLocation()));
            workItem.setSummary(new Linkable(workPackage.getSubject(), workPackage.getSelf().getLocation()));
        }
    }

    private static void setAssignments(WorkItem workItem, WorkPackage workPackage) {
        if (workPackage.getAuthor() != null) {
            workItem.setCreator(workPackage.getAuthor());
        }
        if (workPackage.getAssignee() != null) {
            workItem.setAssignees(List.of(workPackage.getAssignee()));
        }
    }

    private static void setProjectAndPriority(WorkItem workItem, WorkPackage workPackage) {
        if (workPackage.getProject() != null) {
            workItem.setProject(workPackage.getProject());
        }
        if (workPackage.getPriority() != null) {
            workItem.setPriority(workPackage.getPriority().getValue());
        }
    }

    public static <T, R> PaginatedResult<R> convertPaginatedResult(PaginatedResult<T> input, Function<T, R> mapper) {
        PaginatedResult result = new PaginatedResult();
        ArrayList<R> mappedItems = new ArrayList<R>();
        for (Object item : input.getItems()) {
            mappedItems.add(mapper.apply(item));
        }
        result.setItems(mappedItems);
        result.setPage(input.getPage());
        result.setPageSize(input.getPageSize());
        result.setTotalItems(input.getTotalItems());
        return result;
    }
}

