/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.openproject.internal;

import com.xwiki.projectmanagement.exception.ProjectManagementException;
import com.xwiki.projectmanagement.model.PaginatedResult;
import com.xwiki.projectmanagement.openproject.OpenProjectApiClient;
import com.xwiki.projectmanagement.openproject.model.BaseOpenProjectObject;
import com.xwiki.projectmanagement.openproject.model.Priority;
import com.xwiki.projectmanagement.openproject.model.Project;
import com.xwiki.projectmanagement.openproject.model.Status;
import com.xwiki.projectmanagement.openproject.model.Type;
import com.xwiki.projectmanagement.openproject.model.User;
import com.xwiki.projectmanagement.openproject.model.UserAvatar;
import com.xwiki.projectmanagement.openproject.model.WorkPackage;
import org.xwiki.cache.Cache;

public class CachingOpenProjectApiClient
implements OpenProjectApiClient {
    private final Cache<PaginatedResult<? extends BaseOpenProjectObject>> cache;
    private final OpenProjectApiClient client;
    private final String clientId;

    public CachingOpenProjectApiClient(OpenProjectApiClient client, String clientId, Cache<PaginatedResult<? extends BaseOpenProjectObject>> cache) {
        this.client = client;
        this.clientId = clientId;
        this.cache = cache;
    }

    @Override
    public PaginatedResult<WorkPackage> getWorkPackages(int offset, int pageSize, String filters, String sortBy) throws ProjectManagementException {
        String cacheKey = this.getCacheKey("workItems", offset, pageSize, filters, sortBy);
        PaginatedResult<WorkPackage> result = (PaginatedResult<WorkPackage>)this.cache.get(cacheKey);
        if (result == null) {
            result = this.client.getWorkPackages(offset, pageSize, filters, sortBy);
            this.cache.set(cacheKey, result);
        }
        return result;
    }

    @Override
    public PaginatedResult<WorkPackage> getProjectWorkPackages(String project, int offset, int pageSize, String filters, String sortBy) throws ProjectManagementException {
        String cacheKey = this.getCacheKey(String.format("project%sWorkItems", project), offset, pageSize, filters, sortBy);
        PaginatedResult<WorkPackage> result = (PaginatedResult<WorkPackage>)this.cache.get(cacheKey);
        if (result == null) {
            result = this.client.getProjectWorkPackages(project, offset, pageSize, filters, sortBy);
            this.cache.set(cacheKey, result);
        }
        return result;
    }

    @Override
    public PaginatedResult<User> getUsers(int offset, int pageSize, String filters) throws ProjectManagementException {
        String cacheKey = this.getCacheKey("users", offset, pageSize, filters, "");
        PaginatedResult<User> result = (PaginatedResult<User>)this.cache.get(cacheKey);
        if (result == null) {
            result = this.client.getUsers(offset, pageSize, filters);
            this.cache.set(cacheKey, result);
        }
        return result;
    }

    @Override
    public PaginatedResult<Project> getProjects(int offset, int pageSize, String filters) throws ProjectManagementException {
        String cacheKey = this.getCacheKey("projects", offset, pageSize, filters, "");
        PaginatedResult<Project> result = (PaginatedResult<Project>)this.cache.get(cacheKey);
        if (result == null) {
            result = this.client.getProjects(offset, pageSize, filters);
            this.cache.set(cacheKey, result);
        }
        return result;
    }

    @Override
    public PaginatedResult<Type> getTypes() throws ProjectManagementException {
        String cacheKey = this.getCacheKey("types", 1, Integer.MAX_VALUE, "", "");
        PaginatedResult<Type> result = (PaginatedResult<Type>)this.cache.get(cacheKey);
        if (result == null) {
            result = this.client.getTypes();
            this.cache.set(cacheKey, result);
        }
        return result;
    }

    @Override
    public PaginatedResult<Status> getStatuses() throws ProjectManagementException {
        String cacheKey = this.getCacheKey("statuses", 1, Integer.MAX_VALUE, "", "");
        PaginatedResult<Status> result = (PaginatedResult<Status>)this.cache.get(cacheKey);
        if (result == null) {
            result = this.client.getStatuses();
            this.cache.set(cacheKey, result);
        }
        return result;
    }

    @Override
    public PaginatedResult<Priority> getPriorities() throws ProjectManagementException {
        String cacheKey = this.getCacheKey("priorities", 1, Integer.MAX_VALUE, "", "");
        PaginatedResult<Priority> result = (PaginatedResult<Priority>)this.cache.get(cacheKey);
        if (result == null) {
            result = this.client.getPriorities();
            this.cache.set(cacheKey, result);
        }
        return result;
    }

    @Override
    public UserAvatar getUserAvatar(String userId) throws ProjectManagementException {
        return this.client.getUserAvatar(userId);
    }

    private String getCacheKey(String entity, int offset, int pageSize, String filters, String sortBy) {
        return String.format("%s/%s/%d/%d/%s/%s", this.clientId, entity, offset, pageSize, filters, sortBy);
    }
}

