/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal.macro;

import com.xwiki.projectmanagement.macro.ProjectManagementMacroParameters;
import java.util.Collections;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.block.AbstractBlockAsyncRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(roles={ProjectManagementAsyncRenderer.class})
public class ProjectManagementAsyncRenderer
extends AbstractBlockAsyncRenderer {
    private Macro<ProjectManagementMacroParameters> workItemsDisplayer;
    private ProjectManagementMacroParameters parameters;
    private String content;
    private MacroTransformationContext transformationContext;
    private Syntax targetSyntax;
    private List<String> id;

    public void initialize(Macro<ProjectManagementMacroParameters> displayer, ProjectManagementMacroParameters parameters, String content, MacroTransformationContext context) {
        this.workItemsDisplayer = displayer;
        this.parameters = parameters;
        this.content = content;
        this.transformationContext = context;
        this.targetSyntax = context.getTransformationContext().getTargetSyntax();
        StringBuilder sb = new StringBuilder();
        sb.append(parameters.getId()).append(parameters.getProperties()).append(parameters.getFilters()).append(parameters.getSourceParameters());
        this.id = this.createId(new Object[]{"rendering", "macro", "projectmanagement", String.valueOf(sb.toString().hashCode())});
    }

    protected Block execute(boolean async, boolean cached) throws RenderingException {
        try {
            List<MacroMarkerBlock> result = this.workItemsDisplayer.execute((Object)this.parameters, this.content, this.transformationContext);
            MacroBlock currentMacro = this.transformationContext.getCurrentMacroBlock();
            if (currentMacro != null) {
                result = Collections.singletonList(new MacroMarkerBlock(currentMacro.getId(), currentMacro.getParameters(), currentMacro.getContent(), (List)result, currentMacro.isInline()));
            }
            return new CompositeBlock((List)result);
        }
        catch (MacroExecutionException e) {
            throw new RenderingException("Failed to render asynchronously the work items displayer [{}].", (Throwable)e);
        }
    }

    public boolean isInline() {
        return false;
    }

    public Syntax getTargetSyntax() {
        return this.targetSyntax;
    }

    public List<String> getId() {
        return this.id;
    }

    public boolean isAsyncAllowed() {
        return true;
    }

    public boolean isCacheAllowed() {
        return false;
    }
}

