/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal.macro;

import com.xwiki.projectmanagement.internal.WorkItemsDisplayer;
import com.xwiki.projectmanagement.internal.macro.ProjectManagementAsyncRenderer;
import com.xwiki.projectmanagement.macro.ProjectManagementMacroParameters;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.JobException;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

public abstract class AbstractProjectManagementMacro<T extends ProjectManagementMacroParameters>
extends AbstractMacro<T> {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private BlockAsyncRendererExecutor executor;

    public AbstractProjectManagementMacro(String name, String description, ContentDescriptor descriptor, Class<?> clazz) {
        super(name, description, descriptor, clazz);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(T parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        WorkItemsDisplayer displayer = ((ProjectManagementMacroParameters)((Object)parameters)).getWorkItemsDisplayer();
        ((ProjectManagementMacroParameters)((Object)parameters)).setSource("projectmanagement");
        this.processParameters(parameters);
        String newContent = content;
        if (parameters.getFilters() != null && !parameters.getFilters().isEmpty()) {
            newContent = parameters.getFilters();
            ((ProjectManagementMacroParameters)((Object)parameters)).setFilters("");
        }
        try {
            String displayerId = displayer.name();
            if (WorkItemsDisplayer.liveDataCards.equals((Object)displayer)) {
                ((ProjectManagementMacroParameters)((Object)parameters)).setLayouts("cards,table");
                displayerId = WorkItemsDisplayer.liveData.name();
            }
            Macro displayerMacro = (Macro)this.componentManager.getInstance(Macro.class, displayerId);
            if (!WorkItemsDisplayer.liveData.equals((Object)displayer) && !WorkItemsDisplayer.liveDataCards.equals((Object)displayer)) {
                AsyncRendererConfiguration configuration = new AsyncRendererConfiguration();
                ProjectManagementAsyncRenderer asyncRenderer = (ProjectManagementAsyncRenderer)((Object)this.componentManager.getInstance(ProjectManagementAsyncRenderer.class));
                configuration.setContextEntries(Set.of("user", "wiki", "action", "locale"));
                asyncRenderer.initialize((Macro<ProjectManagementMacroParameters>)displayerMacro, (ProjectManagementMacroParameters)((Object)parameters), newContent, context);
                Block result = this.executor.execute((BlockAsyncRenderer)asyncRenderer, configuration);
                return result instanceof CompositeBlock ? result.getChildren() : Collections.singletonList(result);
            }
            return displayerMacro.execute(parameters, newContent, context);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException(String.format("Could not find the displayer [%s].", displayer.name()), (Throwable)e);
        }
        catch (JobException | RenderingException e) {
            throw new MacroExecutionException(String.format("Failed to asynchronously render the work items using [%s] displayer.", displayer.name()), e);
        }
    }

    public abstract void processParameters(T var1);

    protected void addToSourceParams(T parameters, String key, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        String sourceParameters = parameters.getSourceParameters();
        if (sourceParameters == null || sourceParameters.isEmpty()) {
            ((ProjectManagementMacroParameters)((Object)parameters)).setSourceParameters(String.format("%s=%s", key, value));
        } else {
            ((ProjectManagementMacroParameters)((Object)parameters)).setSourceParameters(String.format("%s&%s=%s", sourceParameters, URLEncoder.encode(key, StandardCharsets.UTF_8), URLEncoder.encode(value, StandardCharsets.UTF_8)));
        }
    }
}

