/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal.displayers;

import com.xwiki.projectmanagement.exception.WorkItemException;
import com.xwiki.projectmanagement.internal.displayers.AbstractWorkItemsDisplayer;
import com.xwiki.projectmanagement.internal.utility.TableBuilder;
import com.xwiki.projectmanagement.macro.ProjectManagementMacroParameters;
import com.xwiki.projectmanagement.model.Linkable;
import com.xwiki.projectmanagement.model.PaginatedResult;
import com.xwiki.projectmanagement.model.WorkItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.SpecialSymbolBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Singleton
@Named(value="workItemsSingle")
public class WorkItemsSingleDisplayer
extends AbstractWorkItemsDisplayer {
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String KEY_INSTANCE = "instance";
    private static final Map<String, String> CLASS_ROW = Collections.singletonMap("class", "row");
    private static final Map<String, String> CLASS_COL_3 = Collections.singletonMap("class", "col-md-4 col-xs-12");
    private static final Map<String, String> CLASS_COL_1 = Collections.singletonMap("class", "col-md-12");
    private static final Map<String, String> PROP_NAME_PARAMS = Collections.singletonMap("class", "work-item-property-name");
    private static final Map<String, String> VALUE_PARAMS = Collections.singletonMap("class", "work-item-property-value");
    private static final String PREFIX_PROPERTY = "property.";
    @Inject
    private ContextualLocalizationManager localizationManager;

    public WorkItemsSingleDisplayer() {
        super("Single work item displayer.", "Display the first resulted work item in a page style.");
    }

    public boolean supportsInlineMode() {
        return false;
    }

    @Override
    protected PaginatedResult<WorkItem> getWorkItems(String clientId, ProjectManagementMacroParameters parameters, List<LiveDataQuery.Filter> filters, List<LiveDataQuery.SortEntry> sortEntries) throws WorkItemException {
        parameters.setLimit(1);
        return super.getWorkItems(clientId, parameters, filters, sortEntries);
    }

    @Override
    protected List<Block> internalExecute(PaginatedResult<WorkItem> workItemList, ProjectManagementMacroParameters parameters, MacroTransformationContext context) {
        this.ssrx.use("css/projectmanagement/displayer/single.css", Collections.singletonMap("forceSkinAction", true));
        String translationPrefix = (String)this.macroContext.get("translationPrefix");
        if (workItemList.getItems().size() <= 0) {
            String noWorkItemMessage = null;
            if (translationPrefix != null) {
                noWorkItemMessage = this.localizationManager.getTranslationPlain(String.format("%s.%s", translationPrefix, "macro.noItems"), new Object[0]);
            }
            if (noWorkItemMessage == null) {
                noWorkItemMessage = "There are no work items matching this filter.";
            }
            return Collections.singletonList(new MacroBlock("warning", Collections.emptyMap(), noWorkItemMessage, false));
        }
        WorkItem workItem = (WorkItem)workItemList.getItems().get(0);
        GroupBlock header = this.getHeaderBlock(translationPrefix, workItem);
        Block project = this.getProjectBlock(translationPrefix, workItem);
        Block description = this.getDescriptionBlock(translationPrefix, workItem);
        Block bodyBlocks = this.getBodyBlocks(workItem, translationPrefix);
        return Collections.singletonList(new GroupBlock(Arrays.asList(header, project, bodyBlocks, description), Collections.singletonMap(ATTRIBUTE_CLASS, "work-item-page-displayer")));
    }

    private Block getDescriptionBlock(String translationPrefix, WorkItem workItem) {
        String description = (String)workItem.remove((Object)"description");
        List<Block> propertyNameBlock = this.getTranslationBlocks("description", translationPrefix + PREFIX_PROPERTY);
        List descriptionBlocks = this.getPropertyDisplayerManager().displayProperty("description", (Object)description, Collections.emptyMap());
        return new GroupBlock(Arrays.asList(new GroupBlock(propertyNameBlock, PROP_NAME_PARAMS), new ParagraphBlock(descriptionBlocks)), Collections.singletonMap(ATTRIBUTE_CLASS, "work-package-description"));
    }

    private Block getBodyBlocks(WorkItem workItem, String translationPrefix) {
        TableBuilder tableGeneralProps = new TableBuilder();
        TableBuilder tableLinkables = new TableBuilder();
        TableBuilder tableTimeProps = new TableBuilder();
        String propertyPrefix = translationPrefix + PREFIX_PROPERTY;
        Map<String, WorkItem> displayerParams = Map.of(KEY_INSTANCE, this.macroContext.getContext().getOrDefault(KEY_INSTANCE, "").toString(), "workItem", workItem);
        for (Map.Entry property : workItem.entrySet()) {
            if (property.getValue() == null) continue;
            List<Block> propertyNameBlock = this.getTranslationBlocks((String)property.getKey(), propertyPrefix);
            propertyNameBlock.add((Block)new SpecialSymbolBlock(':'));
            List propertyValueBlock = this.getPropertyDisplayerManager().displayProperty((String)property.getKey(), property.getValue(), displayerParams);
            TableBuilder chosenSection = tableGeneralProps;
            if (property.getValue() instanceof Date) {
                chosenSection = tableTimeProps;
            } else if (property.getValue() instanceof Linkable || WorkItemsSingleDisplayer.isCollectionOfLinkables(property)) {
                chosenSection = tableLinkables;
            }
            chosenSection.newRow().newCell(propertyNameBlock, PROP_NAME_PARAMS).newCell(propertyValueBlock, VALUE_PARAMS);
        }
        Block generalPropsBlock = this.getBootstrap3Col(Collections.singletonList(tableGeneralProps.build()));
        Block linkablePropsBlock = this.getBootstrap3Col(Collections.singletonList(tableLinkables.build()));
        Block timePropsBlock = this.getBootstrap3Col(Collections.singletonList(tableTimeProps.build()));
        return this.getBootstrapRow(Arrays.asList(generalPropsBlock, linkablePropsBlock, timePropsBlock));
    }

    private static boolean isCollectionOfLinkables(Map.Entry<String, Object> property) {
        Object value = property.getValue();
        if (!(value instanceof Collection)) {
            return false;
        }
        if (((Collection)value).isEmpty()) {
            return false;
        }
        Object valueFromCollection = ((Collection)value).iterator().next();
        return valueFromCollection instanceof Linkable;
    }

    private Block getProjectBlock(String translationPrefix, WorkItem workItem) {
        List<Block> projectBlocks = this.getTranslationBlocks("displayer.single.project.prefix", translationPrefix);
        projectBlocks.add((Block)new SpecialSymbolBlock(':'));
        projectBlocks.add((Block)new SpaceBlock());
        projectBlocks.addAll(this.getPropertyDisplayerManager().displayProperty("project", (Object)workItem.getProject(), Collections.emptyMap()));
        Block colBlock = this.getBootstrap1Col(Collections.singletonList(new ParagraphBlock(projectBlocks)));
        workItem.remove((Object)"project");
        return this.getBootstrapRow(Collections.singletonList(colBlock));
    }

    private Block getBootstrapRow(List<Block> children) {
        return new GroupBlock(children, CLASS_ROW);
    }

    private Block getBootstrap3Col(List<Block> children) {
        return new GroupBlock(children, CLASS_COL_3);
    }

    private Block getBootstrap1Col(List<Block> children) {
        return new GroupBlock(children, CLASS_COL_1);
    }

    private GroupBlock getHeaderBlock(String translationPrefix, WorkItem workItem) {
        List<Block> headerId = this.getTranslationBlocks("displayer.single.header.workItem", translationPrefix);
        headerId.add((Block)new SpaceBlock());
        headerId.add((Block)new LinkBlock(Arrays.asList(new SpecialSymbolBlock('#'), new WordBlock(workItem.getLinkableValue("identifier"))), new ResourceReference(workItem.getLinkableLocation("identifier"), ResourceType.URL), false));
        List headerName = this.getPropertyDisplayerManager().displayProperty(String.class.getName(), (Object)workItem.getLinkableValue("summary"), Collections.emptyMap());
        workItem.remove((Object)"identifier");
        workItem.remove((Object)"summary");
        GroupBlock headerIdGroup = new GroupBlock(Collections.singletonList(new ParagraphBlock(headerId)), Collections.singletonMap(ATTRIBUTE_CLASS, "work-item-header-id"));
        GroupBlock headerNameGroup = new GroupBlock(Collections.singletonList(new ParagraphBlock(headerName)), Collections.singletonMap(ATTRIBUTE_CLASS, "work-item-header-name"));
        return new GroupBlock(Arrays.asList(headerNameGroup, headerIdGroup), Collections.singletonMap(ATTRIBUTE_CLASS, "work-item-header"));
    }

    private List<Block> getTranslationBlocks(String key, String translationPrefix) {
        ArrayList<Block> returnList = null;
        String translationKey = translationPrefix + key;
        if (this.localizationManager.getTranslation(translationKey) == null) {
            returnList = this.getPropertyDisplayerManager().displayProperty(String.class.getName(), (Object)translationKey, Collections.emptyMap());
        } else {
            returnList = new ArrayList<Block>();
            returnList.add(this.localizationManager.getTranslation(translationKey).render(new Object[0]));
        }
        return returnList;
    }
}

