/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal.displayers;

import com.xwiki.projectmanagement.ProjectManagementClientExecutionContext;
import com.xwiki.projectmanagement.ProjectManagementManager;
import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayerManager;
import com.xwiki.projectmanagement.exception.WorkItemException;
import com.xwiki.projectmanagement.internal.DefaultProjectManagementClientExecutionContext;
import com.xwiki.projectmanagement.macro.ProjectManagementMacroParameters;
import com.xwiki.projectmanagement.model.PaginatedResult;
import com.xwiki.projectmanagement.model.WorkItem;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;

public abstract class AbstractWorkItemsDisplayer
extends AbstractMacro<ProjectManagementMacroParameters> {
    private static final String KEY_CLIENT = "client";
    @Inject
    @Named(value="ssrx")
    protected SkinExtension ssrx;
    @Inject
    protected ProjectManagementManager projectManagementManager;
    @Inject
    protected ProjectManagementClientExecutionContext macroContext;
    @Inject
    private LiveDataConfigurationResolver<String> stringLiveDataConfigResolver;
    @Inject
    private WorkItemPropertyDisplayerManager displayerManager;
    @Inject
    private ComponentManager componentManager;

    public AbstractWorkItemsDisplayer(String name, String description) {
        super(name, description, ProjectManagementMacroParameters.class);
    }

    public List<Block> execute(ProjectManagementMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<LiveDataQuery.Filter> filters;
        String clientId;
        if (this.macroContext instanceof DefaultProjectManagementClientExecutionContext) {
            Map<String, Object> clientContext = URLEncodedUtils.parse((String)parameters.getSourceParameters(), (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
            ((DefaultProjectManagementClientExecutionContext)this.macroContext).setContext(clientContext);
        }
        if ((clientId = (String)this.macroContext.get(KEY_CLIENT)) == null || clientId.isEmpty()) {
            throw new MacroExecutionException("Failed to retrieve the client id from the source params.");
        }
        try {
            filters = this.getFilters(content);
        }
        catch (LiveDataException e) {
            throw new MacroExecutionException("Failed to parse the filters.");
        }
        List<LiveDataQuery.SortEntry> sortEntries = this.getSortEntries(parameters.getSort());
        PaginatedResult<WorkItem> workItemList = null;
        try {
            workItemList = this.getWorkItems(clientId, parameters, filters, sortEntries);
        }
        catch (WorkItemException e) {
            throw new MacroExecutionException(String.format("Failed to retrieve the work items from the client [%s].", clientId), (Throwable)e);
        }
        return this.internalExecute(workItemList, parameters, context);
    }

    protected abstract List<Block> internalExecute(PaginatedResult<WorkItem> var1, ProjectManagementMacroParameters var2, MacroTransformationContext var3);

    protected void setDefaultCategories(Set<String> defaultCategories) {
        super.setDefaultCategories(Collections.singleton("Internal"));
    }

    protected PaginatedResult<WorkItem> getWorkItems(String clientId, ProjectManagementMacroParameters parameters, List<LiveDataQuery.Filter> filters, List<LiveDataQuery.SortEntry> sortEntries) throws WorkItemException {
        long offset = parameters.getOffset() == null ? 0L : parameters.getOffset();
        return this.projectManagementManager.getWorkItems(clientId, Math.toIntExact(offset), parameters.getLimit().intValue(), filters, sortEntries);
    }

    protected WorkItemPropertyDisplayerManager getPropertyDisplayerManager() {
        String clientId = (String)this.macroContext.get(KEY_CLIENT);
        if (clientId == null || clientId.isEmpty()) {
            return this.displayerManager;
        }
        try {
            return (WorkItemPropertyDisplayerManager)this.componentManager.getInstance(WorkItemPropertyDisplayerManager.class, clientId);
        }
        catch (ComponentLookupException e) {
            return this.displayerManager;
        }
    }

    private List<LiveDataQuery.Filter> getFilters(String filtersString) throws LiveDataException {
        String serializedCfg = filtersString == null ? "" : filtersString;
        LiveDataConfiguration configuration = this.stringLiveDataConfigResolver.resolve((Object)serializedCfg);
        if (configuration == null) {
            return Collections.emptyList();
        }
        if (configuration.getQuery() == null || configuration.getQuery().getFilters() == null) {
            return Collections.emptyList();
        }
        return configuration.getQuery().getFilters();
    }

    private List<LiveDataQuery.SortEntry> getSortEntries(String sort) {
        if (sort == null || sort.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LiveDataQuery.SortEntry> sortEntries = new ArrayList<LiveDataQuery.SortEntry>();
        for (String strSortEntry : sort.split("\\s*,\\s*")) {
            String[] components = strSortEntry.split(":");
            String property = components[0];
            LiveDataQuery.SortEntry sortEntry = new LiveDataQuery.SortEntry(property);
            if (components.length >= 2) {
                sortEntry.setDescending("desc".equals(components[1]));
            }
            sortEntries.add(sortEntry);
        }
        return sortEntries;
    }
}

