/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.livadata.internal.displayer;

import com.xwiki.projectmanagement.ProjectManagementClientExecutionContext;
import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayerManager;
import com.xwiki.projectmanagement.livadata.displayer.ProjectManagementLiveDataDisplayer;
import com.xwiki.projectmanagement.model.WorkItem;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

@Component
@Singleton
public class DefaultProjectManagementLiveDataDisplayer
implements ProjectManagementLiveDataDisplayer {
    @Inject
    protected WorkItemPropertyDisplayerManager defaultDisplayerManager;
    @Inject
    @Named(value="html/5.0")
    protected PrintRendererFactory htmlRendererFactory;
    @Inject
    protected Logger logger;
    @Inject
    protected ComponentManager componentManager;
    @Inject
    private ProjectManagementClientExecutionContext executionContext;

    @Override
    public void display(Collection<WorkItem> workItems) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        PrintRenderer renderer = this.htmlRendererFactory.createRenderer((WikiPrinter)printer);
        for (WorkItem item : workItems) {
            for (Map.Entry itemProperty : item.entrySet()) {
                WorkItemPropertyDisplayerManager displayerManager = this.getPropertyDisplayerManager();
                this.displayProperty(itemProperty, item, renderer, displayerManager);
                printer.clear();
            }
        }
    }

    @Override
    public void displayProperty(Map.Entry<String, Object> itemProperty, WorkItem workItem, PrintRenderer renderer, WorkItemPropertyDisplayerManager displayerManager) {
        if (displayerManager.getDisplayerForProperty(itemProperty.getKey()) != null || itemProperty.getValue() instanceof Date) {
            this.setValueFromBlocksDisplayer(itemProperty, renderer, displayerManager, Collections.singletonMap("workItem", workItem));
        }
    }

    protected void setValueFromBlocksDisplayer(Map.Entry<String, Object> itemProperty, PrintRenderer renderer, WorkItemPropertyDisplayerManager propertyDisplayerManager, Map<String, Object> displayerParams) {
        List representation = propertyDisplayerManager.displayProperty(itemProperty.getKey(), itemProperty.getValue(), displayerParams);
        XDOM xdom = new XDOM(representation);
        xdom.traverse((Listener)renderer);
        String html = renderer.getPrinter().toString();
        itemProperty.setValue(html);
    }

    protected WorkItemPropertyDisplayerManager getPropertyDisplayerManager() {
        String clientId = (String)this.executionContext.get("client");
        if (clientId == null || clientId.isEmpty()) {
            return this.defaultDisplayerManager;
        }
        if (!this.componentManager.hasComponent(WorkItemPropertyDisplayerManager.class, clientId)) {
            return this.defaultDisplayerManager;
        }
        try {
            return (WorkItemPropertyDisplayerManager)this.componentManager.getInstance(WorkItemPropertyDisplayerManager.class, clientId);
        }
        catch (ComponentLookupException e) {
            return this.defaultDisplayerManager;
        }
    }
}

