/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.livadata;

import com.xwiki.projectmanagement.ProjectManagementClientExecutionContext;
import com.xwiki.projectmanagement.ProjectManagementManager;
import com.xwiki.projectmanagement.exception.WorkItemException;
import com.xwiki.projectmanagement.internal.DefaultProjectManagementClientExecutionContext;
import com.xwiki.projectmanagement.livadata.displayer.ProjectManagementLiveDataDisplayer;
import com.xwiki.projectmanagement.model.PaginatedResult;
import com.xwiki.projectmanagement.model.WorkItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.livedata.LiveData;
import org.xwiki.livedata.LiveDataEntryStore;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;

@Component
@Named(value="projectmanagement")
@Singleton
public class ProjectManagementEntryStore
implements LiveDataEntryStore {
    private static final List<String> LINK_PROPERTIES = List.of("identifier", "summary", "creator", "project", "reporter");
    private static final String FLATTEN_FORMAT = "%s.%s";
    private Map<String, Map<String, Object>> db = new HashMap<String, Map<String, Object>>();
    @Inject
    private ProjectManagementManager projectManagementManager;
    @Inject
    private ProjectManagementLiveDataDisplayer defaultDisplayer;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private ProjectManagementClientExecutionContext clientContext;

    public Optional<Map<String, Object>> get(Object entryId) throws LiveDataException {
        return Optional.of(this.db.get(entryId));
    }

    public Optional<Object> get(Object entryId, String property) throws LiveDataException {
        return super.get(entryId, property);
    }

    public LiveData get(LiveDataQuery query) throws LiveDataException {
        LiveData ld = new LiveData();
        String clientId = query.getSource().getParameters().getOrDefault("client", "");
        if (clientId.isEmpty()) {
            throw new LiveDataException("The client property was not specified in the source parameters.");
        }
        if (this.clientContext instanceof DefaultProjectManagementClientExecutionContext) {
            ((DefaultProjectManagementClientExecutionContext)this.clientContext).setContext(query.getSource().getParameters());
        }
        PaginatedResult workItems = null;
        try {
            workItems = this.projectManagementManager.getWorkItems(clientId, Math.toIntExact(query.getOffset()), query.getLimit().intValue(), query.getFilters(), query.getSort());
        }
        catch (WorkItemException e) {
            throw new LiveDataException("Failed to retrieve the work items.", (Throwable)e);
        }
        ld.getEntries().addAll(workItems.getItems());
        ld.setCount((long)workItems.getTotalItems());
        this.applyDisplayers(workItems.getItems(), clientId);
        ProjectManagementEntryStore.flatten(ld);
        return ld;
    }

    private void applyDisplayers(List<WorkItem> workItems, String clientId) {
        if (!this.componentManager.hasComponent(ProjectManagementLiveDataDisplayer.class, clientId)) {
            this.defaultDisplayer.display(workItems);
            return;
        }
        try {
            ProjectManagementLiveDataDisplayer displayer = (ProjectManagementLiveDataDisplayer)this.componentManager.getInstance(ProjectManagementLiveDataDisplayer.class, clientId);
            displayer.display(workItems);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to find the project management livedata displayer with hint [{}].", (Object)clientId);
        }
    }

    private static void flatten(LiveData ld) {
        for (Map entry : ld.getEntries()) {
            for (String linkWorkItemProperty : LINK_PROPERTIES) {
                Object property = entry.get(linkWorkItemProperty);
                if (property == null || !(property instanceof Map)) continue;
                Map linkableProperty = (Map)property;
                entry.put(String.format(FLATTEN_FORMAT, linkWorkItemProperty, "location"), linkableProperty.get("location"));
                entry.put(String.format(FLATTEN_FORMAT, linkWorkItemProperty, "value"), linkableProperty.get("value"));
                entry.remove(linkWorkItemProperty);
            }
        }
    }

    public Optional<Object> save(Map<String, Object> entry) throws LiveDataException {
        return super.save(entry);
    }

    public Optional<Object> update(Object entryId, String property, Object value) throws LiveDataException {
        return super.update(entryId, property, value);
    }

    public Optional<Map<String, Object>> remove(Object entryId) throws LiveDataException {
        return super.remove(entryId);
    }
}

