/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.livadata;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.livedata.LiveDataActionDescriptor;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.internal.JSONMerge;
import org.xwiki.localization.ContextualLocalizationManager;

@Component
@Singleton
@Named(value="projectmanagement")
public class ProjectManagementConfigurationResolver
implements LiveDataConfigurationResolver<LiveDataConfiguration> {
    private static final String PREFIX_PROPERTY = "property.";
    private static final CharSequence PREFIX_ACTION = "action.";
    private static final String SUFFIX_HINT = ".hint";
    @Inject
    private ContextualLocalizationManager l10n;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private LiveDataConfigurationResolver<String> stringLiveDataConfigResolver;
    private String defaultSerializedConfig;
    private final Map<String, String> clientSerializedConfigs = new HashMap<String, String>();
    private final JSONMerge jsonMerge = new JSONMerge();

    public LiveDataConfiguration resolve(LiveDataConfiguration input) throws LiveDataException {
        LiveDataConfiguration defaultConfig = this.getDefaultConfiguration();
        defaultConfig = this.translate(defaultConfig);
        defaultConfig.setId(input.getId());
        LiveDataConfiguration clientConfig = this.maybeGetClientConfiguration(input);
        LiveDataConfiguration mergedConfig = null;
        if (clientConfig != null) {
            mergedConfig = (LiveDataConfiguration)this.jsonMerge.merge((Object[])new LiveDataConfiguration[]{defaultConfig, clientConfig});
        }
        mergedConfig = mergedConfig != null ? (LiveDataConfiguration)this.jsonMerge.merge((Object[])new LiveDataConfiguration[]{mergedConfig, input}) : (LiveDataConfiguration)this.jsonMerge.merge((Object[])new LiveDataConfiguration[]{defaultConfig, input});
        return this.translate(mergedConfig);
    }

    private LiveDataConfiguration getDefaultConfiguration() {
        try {
            if (this.defaultSerializedConfig != null && !this.defaultSerializedConfig.isEmpty()) {
                return this.stringLiveDataConfigResolver.resolve((Object)this.defaultSerializedConfig);
            }
            InputStream defaultConfigInputStream = this.getClass().getResourceAsStream("/projectManagementLiveDataConfiguration.json");
            this.defaultSerializedConfig = defaultConfigInputStream == null ? "" : IOUtils.toString((InputStream)defaultConfigInputStream, (String)"UTF-8");
            return this.stringLiveDataConfigResolver.resolve((Object)this.defaultSerializedConfig);
        }
        catch (IOException | LiveDataException e) {
            return null;
        }
    }

    private LiveDataConfiguration maybeGetClientConfiguration(LiveDataConfiguration inputConfig) {
        String clientId = (String)inputConfig.getQuery().getSource().getParameters().get("client");
        if (clientId == null || clientId.isEmpty()) {
            return null;
        }
        try {
            DefaultParameterizedType clientCfgProviderType = new DefaultParameterizedType(null, LiveDataConfigurationResolver.class, new Type[]{LiveDataConfiguration.class});
            if (this.componentManager.hasComponent((Type)clientCfgProviderType, clientId)) {
                LiveDataConfigurationResolver clientCfgProvider = (LiveDataConfigurationResolver)this.componentManager.getInstance((Type)clientCfgProviderType, clientId);
                return clientCfgProvider.resolve((Object)inputConfig);
            }
            String serializedCfg = this.clientSerializedConfigs.get(clientId);
            if (serializedCfg == null) {
                InputStream inputStream = this.getClass().getResourceAsStream(String.format("/%sProjectManagementLiveDataConfiguration.json", clientId));
                if (inputStream == null) {
                    return null;
                }
                serializedCfg = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            this.clientSerializedConfigs.put(clientId, serializedCfg);
            return this.stringLiveDataConfigResolver.resolve((Object)serializedCfg);
        }
        catch (IOException | ComponentLookupException | LiveDataException e) {
            return null;
        }
    }

    private LiveDataConfiguration translate(LiveDataConfiguration mergedConfig) {
        String translationPrefix = (String)mergedConfig.getQuery().getSource().getParameters().get("translationPrefix");
        if (translationPrefix == null || translationPrefix.isEmpty()) {
            return mergedConfig;
        }
        for (LiveDataPropertyDescriptor property : mergedConfig.getMeta().getPropertyDescriptors()) {
            this.translateProperty(translationPrefix, property);
        }
        if (mergedConfig.getMeta().getActions() == null) {
            return mergedConfig;
        }
        for (LiveDataActionDescriptor action : mergedConfig.getMeta().getActions()) {
            this.translateAction(translationPrefix, action);
        }
        return mergedConfig;
    }

    private void translateAction(String translationPrefix, LiveDataActionDescriptor action) {
        String translationPlain = this.l10n.getTranslationPlain(String.join((CharSequence)"", translationPrefix, PREFIX_ACTION, action.getId()), new Object[0]);
        if (translationPlain != null) {
            action.setName(translationPlain);
        }
        if (action.getName() == null) {
            action.setName(action.getId());
        }
        if (action.getDescription() == null) {
            action.setDescription(this.l10n.getTranslationPlain(String.join((CharSequence)"", translationPrefix, PREFIX_ACTION, action.getId(), SUFFIX_HINT), new Object[0]));
        }
    }

    private void translateProperty(String translationPrefix, LiveDataPropertyDescriptor property) {
        String translationPlain = this.l10n.getTranslationPlain(String.join((CharSequence)"", translationPrefix, PREFIX_PROPERTY, property.getId()), new Object[0]);
        if (translationPlain != null) {
            property.setName(translationPlain);
        }
        if (property.getName() == null) {
            property.setName(property.getId());
        }
        if (property.getDescription() == null) {
            property.setDescription(this.l10n.getTranslationPlain(String.join((CharSequence)"", translationPrefix, PREFIX_PROPERTY, property.getId(), SUFFIX_HINT), new Object[0]));
        }
    }
}

