/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal.displayer.property;

import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayer;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;

public class StringPropertyDisplayer
implements WorkItemPropertyDisplayer {
    private Logger logger = LoggerFactory.getLogger(StringPropertyDisplayer.class);
    private final Parser plainTextParser;

    public StringPropertyDisplayer(Parser parser) {
        this.plainTextParser = parser;
    }

    @Override
    public List<Block> display(Object property, Map<String, Object> params) {
        if (property == null) {
            return Collections.emptyList();
        }
        try {
            List blocks = this.plainTextParser.parse((Reader)new StringReader(property.toString())).getChildren();
            if (blocks == null) {
                return Collections.emptyList();
            }
            if (blocks.size() == 1 && blocks.get(0) instanceof ParagraphBlock) {
                blocks = ((Block)blocks.get(0)).getChildren();
            }
            return blocks;
        }
        catch (ParseException e) {
            this.logger.warn("Failed to parse the property with value [{}] of a work item.", property);
            return Collections.emptyList();
        }
    }
}

