/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal.displayer.property;

import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayer;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;

public class LinkablePropertyDisplayer
implements WorkItemPropertyDisplayer {
    private final Logger logger = LoggerFactory.getLogger(LinkablePropertyDisplayer.class);
    private final Parser plainTextParser;

    public LinkablePropertyDisplayer(Parser parser) {
        this.plainTextParser = parser;
    }

    @Override
    public List<Block> display(Object property, Map<String, Object> params) {
        if (!(property instanceof Map)) {
            return Collections.emptyList();
        }
        String anchor = (String)((Map)property).get("value");
        String url = (String)((Map)property).get("location");
        if (anchor == null || anchor.isEmpty()) {
            return Collections.emptyList();
        }
        List linkAnchorBlocks = Collections.emptyList();
        try {
            linkAnchorBlocks = this.plainTextParser.parse((Reader)new StringReader(anchor)).getChildren();
        }
        catch (ParseException parseException) {
            this.logger.warn("Failed to parse the value [{}] of a linkable property. Cause: [{}].", (Object)anchor, (Object)ExceptionUtils.getRootCauseMessage((Throwable)parseException));
        }
        if (!linkAnchorBlocks.isEmpty() && linkAnchorBlocks.get(0) instanceof ParagraphBlock) {
            linkAnchorBlocks = ((Block)linkAnchorBlocks.get(0)).getChildren();
        }
        boolean freeStanding = linkAnchorBlocks.isEmpty();
        if (StringUtils.isEmpty((CharSequence)url)) {
            return linkAnchorBlocks;
        }
        return Collections.singletonList(new LinkBlock(linkAnchorBlocks, new ResourceReference(url, ResourceType.URL), freeStanding, Collections.singletonMap("target", "_blank")));
    }
}

