/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal.displayer.property;

import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayer;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;

public class DatePropertyDisplayer
implements WorkItemPropertyDisplayer {
    private static final String DEFAULT_DATE_FORMAT = "dd/MM/yyyy hh:mm:ss";
    private final Logger logger = LoggerFactory.getLogger(DatePropertyDisplayer.class);
    private final Parser parser;
    private SimpleDateFormat dateFormatter;

    public DatePropertyDisplayer(Parser parser) {
        this.parser = parser;
        this.dateFormatter = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
    }

    public DatePropertyDisplayer(Parser parser, String dateFormat) {
        this(parser);
        try {
            this.dateFormatter = new SimpleDateFormat(dateFormat);
        }
        catch (IllegalArgumentException ignored) {
            this.dateFormatter = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        }
    }

    @Override
    public List<Block> display(Object property, Map<String, Object> params) {
        if (property == null) {
            return Collections.emptyList();
        }
        Date dateVal = (Date)property;
        SimpleDateFormat formatter = this.dateFormatter;
        String paramsFormat = params.getOrDefault("format", "").toString();
        if (paramsFormat != null && !paramsFormat.isEmpty()) {
            try {
                formatter = new SimpleDateFormat(paramsFormat);
            }
            catch (IllegalArgumentException e) {
                formatter = this.dateFormatter;
            }
        }
        String formattedDate = formatter.format(dateVal);
        try {
            return this.parser.parse((Reader)new StringReader(formattedDate)).getChildren();
        }
        catch (ParseException e) {
            this.logger.warn("Failed to parse the formatted date [{}]. Cause: [{}].", (Object)formattedDate, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Collections.emptyList();
        }
    }
}

