/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal.displayer;

import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayer;
import com.xwiki.projectmanagement.displayer.WorkItemPropertyDisplayerManager;
import com.xwiki.projectmanagement.internal.displayer.property.DatePropertyDisplayer;
import com.xwiki.projectmanagement.internal.displayer.property.LinkablePropertyDisplayer;
import com.xwiki.projectmanagement.internal.displayer.property.ListPropertyDisplayer;
import com.xwiki.projectmanagement.internal.displayer.property.StringPropertyDisplayer;
import com.xwiki.projectmanagement.model.Linkable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.parser.Parser;

@Component
@Singleton
public class DefaultWorkItemPropertyDisplayerManager
implements WorkItemPropertyDisplayerManager,
Initializable {
    @Inject
    @Named(value="plain/1.0")
    private Parser plainParser;
    @Inject
    @Named(value="wiki")
    private ConfigurationSource wikiConfigSource;
    private final Map<String, WorkItemPropertyDisplayer> displayers = new HashMap<String, WorkItemPropertyDisplayer>();

    @Override
    public List<Block> displayProperty(String propertyName, Object propertyValue, Map<String, Object> parameters) {
        WorkItemPropertyDisplayer propertyDisplayer = this.getDisplayerForProperty(propertyName);
        if (propertyValue == null) {
            return Collections.emptyList();
        }
        if (propertyDisplayer == null) {
            propertyDisplayer = this.getDisplayerForProperty(propertyValue.getClass().getName());
        }
        if (propertyValue instanceof Map && ((Map)propertyValue).containsKey("value") && ((Map)propertyValue).containsKey("location")) {
            propertyDisplayer = this.getDisplayerForProperty(Linkable.class.getName());
        }
        if (propertyDisplayer != null) {
            return propertyDisplayer.display(propertyValue, parameters);
        }
        return this.getDisplayerForProperty(String.class.getName()).display(propertyValue.toString(), parameters);
    }

    @Override
    public WorkItemPropertyDisplayer getDisplayerForProperty(String property) {
        return this.displayers.get(property);
    }

    public void initialize() throws InitializationException {
        LinkablePropertyDisplayer linkableDisplayer = new LinkablePropertyDisplayer(this.plainParser);
        this.displayers.put(Linkable.class.getName(), linkableDisplayer);
        this.displayers.put("identifier", linkableDisplayer);
        this.displayers.put("summary", linkableDisplayer);
        this.displayers.put("project", linkableDisplayer);
        this.displayers.put("creator", linkableDisplayer);
        this.displayers.put(String.class.getName(), new StringPropertyDisplayer(this.plainParser));
        ListPropertyDisplayer propertyDisplayer = new ListPropertyDisplayer(this);
        this.displayers.put("assignees", propertyDisplayer);
        this.displayers.put("labels", propertyDisplayer);
        this.displayers.put("list", propertyDisplayer);
        String format = (String)this.wikiConfigSource.getProperty("dateformat", (Object)"dd/MM/yyyy hh:mm:ss");
        this.displayers.put(Date.class.getName(), new DatePropertyDisplayer(this.plainParser, format));
    }
}

