/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.internal;

import com.xwiki.projectmanagement.ProjectManagementClient;
import com.xwiki.projectmanagement.ProjectManagementManager;
import com.xwiki.projectmanagement.exception.WorkItemException;
import com.xwiki.projectmanagement.model.PaginatedResult;
import com.xwiki.projectmanagement.model.WorkItem;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.livedata.LiveDataQuery;

@Component
@Singleton
public class DefaultProjectManagementManager
implements ProjectManagementManager {
    @Inject
    private ComponentManager componentManager;

    @Override
    public WorkItem getWorkItem(String client, String workItemId) throws WorkItemException {
        return this.getClient(client).getWorkItem(workItemId);
    }

    @Override
    public PaginatedResult<WorkItem> getWorkItems(String client, int page, int pageSize, List<LiveDataQuery.Filter> filters, List<LiveDataQuery.SortEntry> sortEntries) throws WorkItemException {
        return this.getClient(client).getWorkItems(page, pageSize, filters, sortEntries);
    }

    @Override
    public WorkItem createWorkItem(String client, WorkItem workItem) throws WorkItemException {
        return this.getClient(client).createWorkItem(workItem);
    }

    @Override
    public WorkItem updateWorkItem(String client, WorkItem workItem) throws WorkItemException {
        return this.getClient(client).updateWorkItem(workItem);
    }

    @Override
    public boolean deleteWorkItem(String client, String workItemId) throws WorkItemException {
        return this.getClient(client).deleteWorkItem(workItemId);
    }

    private ProjectManagementClient getClient(String hint) throws WorkItemException {
        try {
            return (ProjectManagementClient)this.componentManager.getInstance(ProjectManagementClient.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new WorkItemException(String.format("Failed to retrieve the client with hint [%s].", hint));
        }
    }
}

