/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.pro.test.po.generic;

import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.BaseElement;

public class UserProfileMacro
extends BaseElement {
    private final WebElement userProfile;

    public UserProfileMacro(WebElement container) {
        this.userProfile = container;
    }

    public boolean hasAvatarWithLink(String username) {
        WebElement mediaLeft = this.userProfile.findElement(By.cssSelector((String)".media-left a"));
        String href = mediaLeft.getAttribute("href");
        boolean linkMatches = href != null && href.contains("/xwiki/bin/view/XWiki/" + username);
        WebElement image = mediaLeft.findElement(By.tagName((String)"img"));
        String actualTitle = image.getAttribute("title");
        boolean titleMatches = username.equals(actualTitle);
        return linkMatches && titleMatches;
    }

    public boolean hasProfileLink(String username) {
        WebElement link = this.userProfile.findElement(By.cssSelector((String)".media-heading a"));
        String href = link.getAttribute("href");
        boolean textMatches = username.equals(link.getText());
        return href != null && href.contains("/xwiki/bin/view/XWiki/" + username) && textMatches;
    }

    public List<WebElement> getPropertiesList() {
        return this.userProfile.findElement(By.cssSelector((String)".xwiki-user-profile-body ul")).findElements(By.tagName((String)"li"));
    }

    public List<String> getProperties() {
        return this.getPropertiesList().stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public boolean isEmailLinkCorrect(int propertyIndex, String expectedEmail) {
        WebElement emailElement = this.getPropertiesList().get(propertyIndex);
        WebElement emailLink = emailElement.findElement(By.tagName((String)"a"));
        String href = emailLink.getAttribute("href");
        return href != null && href.equals("mailto:" + expectedEmail);
    }

    public String getComment() {
        return this.userProfile.findElement(By.cssSelector((String)".xwiki-user-profile-comment")).getText();
    }
}

