/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.pro.test.po.generic;

import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.BaseElement;

public class UserListItem
extends BaseElement {
    private final WebElement item;

    public UserListItem(WebElement item) {
        this.item = item;
    }

    public String getAvatarTitle() {
        WebElement img = this.item.findElement(By.cssSelector((String)"td.xwiki-userlist-user-avatar img"));
        return img.getAttribute("title");
    }

    public String getAvatarAlt() {
        WebElement img = this.item.findElement(By.cssSelector((String)"td.xwiki-userlist-user-avatar img"));
        return img.getAttribute("alt");
    }

    public String getUsername() {
        WebElement link = this.item.findElement(By.cssSelector((String)"td.xwiki-userlist-user-username a"));
        return link.getText();
    }

    public boolean hasProfileLink(String username) {
        WebElement link = this.item.findElement(By.cssSelector((String)"td.xwiki-userlist-user-username a"));
        return link.getAttribute("href").contains("/xwiki/bin/view/XWiki/" + username);
    }

    public String getPhone() {
        return this.item.findElement(By.cssSelector((String)"td.xwiki-userlist-user-phone")).getText();
    }

    public String getEmail() {
        return this.item.findElement(By.cssSelector((String)"td.xwiki-userlist-user-email a")).getText();
    }

    public boolean isEmailLinkValid(String expectedEmail) {
        WebElement emailLink = this.item.findElement(By.cssSelector((String)"td.xwiki-userlist-user-email a"));
        return ("mailto:" + expectedEmail).equals(emailLink.getAttribute("href"));
    }

    public String getAddress() {
        List cells = this.item.findElements(By.cssSelector((String)"td.xwiki-userlist-user-address"));
        return cells.isEmpty() ? "" : ((WebElement)cells.get(0)).getText();
    }

    public String getBlogFeed() {
        List cells = this.item.findElements(By.cssSelector((String)"td.xwiki-userlist-user-blogfeed"));
        return cells.isEmpty() ? "" : ((WebElement)cells.get(0)).getText();
    }

    public List<WebElement> getProperties() {
        return this.item.findElements(By.tagName((String)"td"));
    }

    public List<String> getPropertyTypes() {
        return this.getProperties().stream().map(td -> {
            String classAttr = td.getAttribute("class");
            if (classAttr != null && classAttr.startsWith("xwiki-userlist-user-")) {
                return classAttr.substring("xwiki-userlist-user-".length());
            }
            return "";
        }).collect(Collectors.toList());
    }
}

