/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.pro.test.po.generic;

import java.util.List;
import java.util.NoSuchElementException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.BaseElement;

public class TeamMacro
extends BaseElement {
    private final WebElement team;

    public TeamMacro(WebElement team) {
        this.team = team;
    }

    public List<WebElement> getUsers() {
        return this.team.findElements(By.className((String)"xwikiteam-user"));
    }

    public String getUserTitle(String username) {
        return this.getUser(username).getAttribute("title");
    }

    public String getProfileLink(String username) {
        return this.getUser(username).findElement(By.tagName((String)"a")).getAttribute("href");
    }

    public String getAvatarInitials(String username) {
        return this.getUser(username).findElement(By.className((String)"xwikiteam-avatar-initials-letters")).getText();
    }

    public String getAvatarBackgroundColor(String username) {
        return this.getAvatar(username).getCssValue("background-color");
    }

    public String getAvatarFontColor(String username) {
        return this.getUser(username).findElement(By.className((String)"xwikiteam-avatar-initials-letters")).getCssValue("color");
    }

    public String getAvatarSize(String username) {
        return this.getAvatar(username).getCssValue("height");
    }

    public String getAvatarBorderRadius(String username) {
        return this.getAvatar(username).getCssValue("border-radius");
    }

    public boolean hasEmptyTeamMessage() {
        return this.team.getText().equals("There is nobody to show.");
    }

    public boolean isUsernameVisible(String username) {
        WebElement usernameElement = this.getUser(username).findElement(By.className((String)"xwikiteam-username"));
        return usernameElement.isDisplayed();
    }

    private WebElement getUser(String username) {
        return this.getUsers().stream().filter(user -> username.equals(user.getAttribute("data-username"))).findFirst().orElseThrow(() -> new NoSuchElementException("User not found: " + username));
    }

    private WebElement getAvatar(String username) {
        return this.getUser(username).findElement(By.className((String)"xwikiteam-avatar"));
    }
}

