/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.pro.test.po.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.BaseElement;

public class TagListMacro
extends BaseElement {
    private final WebElement tagList;

    public TagListMacro(WebElement tagList) {
        this.tagList = tagList;
    }

    public List<String> getGlossaryTitles() {
        List glossaryTitles = this.tagList.findElements(By.cssSelector((String)".glossaryBinTitle"));
        ArrayList<String> titles = new ArrayList<String>();
        for (WebElement el : glossaryTitles) {
            titles.add(el.getText());
        }
        return titles;
    }

    public List<String> getTagNames() {
        return this.tagList.findElements(By.cssSelector((String)".glossaryBinElement")).stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public boolean hasLink(String tagName) {
        String xpath = ".//li[contains(@class, 'glossaryBinElement')]/a[text()='" + tagName + "']";
        return this.tagList.findElements(By.xpath((String)xpath)).stream().map(WebElement::getTagName).anyMatch(tag -> tag.equals("a"));
    }
}

