/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.pro.test.po.generic;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.BaseElement;

public class PanelMacro
extends BaseElement {
    private final WebElement panel;
    private final WebElement panelBorder;

    public PanelMacro(WebElement panel, WebElement panelBorder) {
        this.panel = panel;
        this.panelBorder = panelBorder;
    }

    public String getWidth() {
        return this.getStyleAttribute(this.panel, "width");
    }

    public String getHeight() {
        return this.getStyleAttribute(this.panel, "height");
    }

    public String getBorderRadius() {
        return this.getStyleAttribute(this.panel, "border-radius");
    }

    public String getBorderStyle() {
        return this.getStyleAttribute(this.panelBorder, "border");
    }

    public String getTitleBackgroundColor() {
        return this.getStyleAttribute(this.getTitleElement(), "background-color");
    }

    public String getTitleColor() {
        return this.getStyleAttribute(this.getTitleElement(), "color");
    }

    public String getTitleText() {
        return this.getTitleElement().getText();
    }

    public String getContentBackgroundColor() {
        return this.getStyleAttribute(this.getContentElement(), "background-color");
    }

    public String getContentColor() {
        return this.getStyleAttribute(this.getContentElement(), "color");
    }

    public String getContentText() {
        return this.getContentElement().getText();
    }

    public String getFooterBackgroundColor() {
        return this.getStyleAttribute(this.getFooterElement(), "background-color");
    }

    public String getFooterColor() {
        return this.getStyleAttribute(this.getFooterElement(), "color");
    }

    public String getFooterText() {
        return this.getFooterElement().getText();
    }

    public String getCssClass() {
        return this.panel.getAttribute("class");
    }

    private WebElement getTitleElement() {
        return this.panel.findElement(By.cssSelector((String)".macro-panel-title"));
    }

    private WebElement getContentElement() {
        return this.panel.findElement(By.cssSelector((String)".macro-panel-content"));
    }

    private WebElement getFooterElement() {
        return this.panel.findElement(By.cssSelector((String)".macro-panel-footer"));
    }

    private String getStyleAttribute(WebElement element, String attr) {
        String style = element.getAttribute("style");
        if (style == null) {
            return null;
        }
        for (String part : style.split(";")) {
            String[] keyValue = part.split(":");
            if (!keyValue[0].trim().equals(attr)) continue;
            return keyValue[1].trim();
        }
        return null;
    }
}

