/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

abstract class AbstractUnprefixedConfluenceBridgeMacro<P>
implements Macro<P> {
    protected static final int PRIORITY = 900;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private Logger logger;

    AbstractUnprefixedConfluenceBridgeMacro() {
    }

    protected abstract String getId();

    protected String getConfluenceBridgeId() {
        return "confluence_" + this.getId();
    }

    public int getPriority() {
        return 900;
    }

    public MacroDescriptor getDescriptor() {
        Macro<P> macro = this.getMacro();
        MacroDescriptor descriptor = macro == null ? null : macro.getDescriptor();
        String id = this.getId();
        return new UnprefixedConfluenceBridgeMacroDescriptor(id, descriptor);
    }

    private Macro<P> getMacro() {
        Macro macro;
        String confluenceBridgeId = this.getConfluenceBridgeId();
        try {
            macro = (Macro)((ComponentManager)this.contextComponentManagerProvider.get()).getInstance(Macro.class, confluenceBridgeId);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Could not find macro [{}]", (Object)confluenceBridgeId, (Object)e);
            return null;
        }
        return macro;
    }

    public boolean supportsInlineMode() {
        Macro<P> macro = this.getMacro();
        if (macro == null) {
            return false;
        }
        return macro.supportsInlineMode();
    }

    public List<Block> execute(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        Macro<P> macro = this.getMacro();
        if (macro == null) {
            return Collections.singletonList(new MacroBlock("error", Collections.emptyMap(), "Could not find the Confluence bridge [" + this.getConfluenceBridgeId() + "].", context.isInline()));
        }
        return macro.execute(parameters, content, context);
    }

    public int compareTo(Macro<?> macro) {
        return this.getPriority() - macro.getPriority();
    }

    private static class UnprefixedConfluenceBridgeMacroDescriptor
    implements MacroDescriptor {
        private static final String DEPRECATED = "Deprecated";
        private static final String LEGACY_UNPREFIXED = "Legacy unprefixed ";
        private static final Set<String> DEFAULT_CATEGORIES = Collections.singleton("Deprecated");
        private final String id;
        private final MacroDescriptor descriptor;

        UnprefixedConfluenceBridgeMacroDescriptor(String id, MacroDescriptor descriptor) {
            this.id = id;
            this.descriptor = descriptor;
        }

        public MacroId getId() {
            return new MacroId(this.id);
        }

        public String getName() {
            return LEGACY_UNPREFIXED + (this.descriptor == null ? this.getFallbackName() : this.descriptor.getName());
        }

        private String getFallbackName() {
            return "Confluence bridge for " + this.id;
        }

        public String getDescription() {
            return "Legacy Unprefixed " + (String)(this.descriptor == null ? this.getFallbackName() + " (failed to get the description of this macro)" : this.descriptor.getDescription());
        }

        public Class<?> getParametersBeanClass() {
            return this.descriptor == null ? WikiMacroParameters.class : this.descriptor.getParametersBeanClass();
        }

        public ContentDescriptor getContentDescriptor() {
            return this.descriptor == null ? null : this.descriptor.getContentDescriptor();
        }

        public Map<String, ParameterDescriptor> getParameterDescriptorMap() {
            return this.descriptor == null ? Collections.emptyMap() : this.descriptor.getParameterDescriptorMap();
        }

        public Set<String> getDefaultCategories() {
            return DEFAULT_CATEGORIES;
        }
    }
}

