/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.confluence.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.resolvers.ConfluenceResolverException;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceKeyResolver;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceResolver;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.stability.Unstable;

@Component(roles={ConfluenceSpaceUtils.class})
@Singleton
@Unstable
public class ConfluenceSpaceUtils {
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ConfluenceSpaceKeyResolver confluenceSpaceKeyResolver;
    @Inject
    private ConfluenceSpaceResolver confluenceSpaceResolver;
    @Inject
    private EntityReferenceResolver<String> resolver;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> serializer;

    public EntityReference getSloppySpace(String spaceKeyOrRef) {
        try {
            if (spaceKeyOrRef.contains("@self")) {
                return this.confluenceSpaceResolver.getSpace((EntityReference)((XWikiContext)this.contextProvider.get()).getDoc().getDocumentReference());
            }
            if (spaceKeyOrRef.startsWith("confluenceSpace:")) {
                String unprefixedSpaceKey = spaceKeyOrRef.substring(spaceKeyOrRef.indexOf(58) + 1);
                return this.confluenceSpaceKeyResolver.getSpaceByKey(unprefixedSpaceKey);
            }
            EntityReference spaceRef = this.resolver.resolve((Object)spaceKeyOrRef, EntityType.SPACE, new Object[0]);
            Query checkSpaceExistence = this.queryManager.createQuery("SELECT count(reference) FROM XWikiSpace s where s.reference=:reference", "hql");
            checkSpaceExistence.bindValue("reference", this.serializer.serialize(spaceRef, new Object[0]));
            long count = (Long)checkSpaceExistence.execute().get(0);
            if (count > 0L) {
                return spaceRef;
            }
            return this.confluenceSpaceKeyResolver.getSpaceByKey(spaceKeyOrRef);
        }
        catch (ConfluenceResolverException e) {
            this.logger.warn("Could not convert space [{}] to an entity reference", (Object)spaceKeyOrRef, (Object)e);
        }
        catch (QueryException e) {
            this.logger.error("Failed to execute query to check if the [{}] space exists.", (Object)spaceKeyOrRef, (Object)e);
        }
        return null;
    }
}

