/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.confluence;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Singleton
@Named(value="filterAttachments")
@Unstable
public class FilterAttachmentsScriptService
implements ScriptService {
    public List<AttachmentReference> filterAttachmentResults(List<AttachmentReference> attachments, List<String> regexes) {
        if (regexes != null && regexes.size() == 1 && regexes.get(0).isEmpty() || regexes.isEmpty()) {
            return attachments;
        }
        List patterns = regexes.stream().map(Pattern::compile).collect(Collectors.toList());
        return attachments.stream().filter(attachment -> patterns.stream().anyMatch(pattern -> pattern.matcher(attachment.getName()).matches())).collect(Collectors.toList());
    }
}

