/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.confluence;

import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.confluence.ConfluenceTocZoneBlockFilter;
import com.xwiki.macros.confluence.ConfluenceTocZoneMacroParameters;
import com.xwiki.macros.confluence.ConfluenceTocZoneMacroTypeParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListBLock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.match.AnyBlockMatcher;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.stability.Unstable;

@Component
@Named(value="confluence_toc-zone")
@Singleton
@Unstable
public class ConfluenceTocZoneMacro
extends AbstractProMacro<ConfluenceTocZoneMacroParameters> {
    private static final String SEMICOLUMN = ";";
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextRenderer;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    private LinkLabelGenerator linkLabelGenerator;

    public ConfluenceTocZoneMacro() {
        super("Confluence Toc Zone", "Confluence bridge macro for toc-zone.", (ContentDescriptor)new DefaultContentDescriptor("Content", true, Block.LIST_BLOCK_TYPE), ConfluenceTocZoneMacroParameters.class);
    }

    public List<Block> internalExecute(ConfluenceTocZoneMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> contentXDOM = this.parseContent(content, context);
        int levelOffset = this.getLevelOffset(contentXDOM, parameters);
        Block toc = parameters.getType().equals((Object)ConfluenceTocZoneMacroTypeParameter.FLAT) ? this.browseXDOMFlat(contentXDOM, levelOffset, context, parameters) : this.browseXDOMList(contentXDOM, levelOffset, parameters);
        StringBuilder classes = new StringBuilder("");
        if (!parameters.isPrintable()) {
            classes.append("hidden-print ");
        }
        classes.append(parameters.getCssClass());
        if (!"".equals(classes.toString())) {
            toc = new GroupBlock(Arrays.asList(toc), Collections.singletonMap("class", classes.toString()));
        }
        ArrayList<Block> result = new ArrayList<Block>();
        switch (parameters.getLocation()) {
            case TOP: {
                result.add(toc);
                result.addAll(contentXDOM);
                break;
            }
            case BOTTOM: {
                result.addAll(contentXDOM);
                result.add(toc);
                break;
            }
            default: {
                result.add(toc);
                result.addAll(contentXDOM);
                result.add(toc);
            }
        }
        return result;
    }

    public boolean supportsInlineMode() {
        return false;
    }

    private Block browseXDOMFlat(List<Block> body, int levelOffset, MacroTransformationContext context, ConfluenceTocZoneMacroParameters parameters) throws MacroExecutionException {
        ParagraphBlock toc = new ParagraphBlock(new ArrayList());
        ArrayList<Integer> outlineLevels = new ArrayList<Integer>();
        String separatorBefore = "";
        String separatorAfter = "";
        String separator = "";
        switch (parameters.getSeparator()) {
            case "brackets": {
                separatorBefore = "[ ";
                separatorAfter = " ] ";
                break;
            }
            case "braces": {
                separatorBefore = "{ ";
                separatorAfter = " } ";
                break;
            }
            case "parens": {
                separatorBefore = "( ";
                separatorAfter = " ) ";
                break;
            }
            case "pipe": {
                separator = " | ";
                break;
            }
            default: {
                separator = parameters.getSeparator();
            }
        }
        List<Block> lastSeparator = Arrays.asList(new Block[0]);
        for (Block block : body) {
            for (Block b : block.getBlocks((BlockMatcher)new AnyBlockMatcher(), Block.Axes.DESCENDANT)) {
                HeaderBlock header;
                if (!(b instanceof HeaderBlock) || this.filterHeader(header = (HeaderBlock)b, parameters)) continue;
                int level = header.getLevel().getAsInt() + levelOffset;
                toc.addChildren(this.parseReadOnlyContent(separatorBefore, context));
                toc.addChild(this.getOutline(level, outlineLevels, parameters));
                toc.addChild((Block)new SpaceBlock());
                toc.addChild((Block)this.getHeaderLink(header));
                toc.addChildren(this.parseReadOnlyContent(separatorAfter, context));
                lastSeparator = this.parseReadOnlyContent(separator, context);
                toc.addChildren(lastSeparator);
            }
        }
        for (Block block : lastSeparator) {
            toc.removeBlock(block);
        }
        return toc;
    }

    private Block browseXDOMList(List<Block> body, int levelOffset, ConfluenceTocZoneMacroParameters parameters) {
        ArrayList<ListBLock> levels = new ArrayList<ListBLock>();
        ArrayList<Integer> outlineLevels = new ArrayList<Integer>();
        Map<String, String> listParameters = Collections.emptyMap();
        StringBuilder style = new StringBuilder("");
        if (!"default".equals(parameters.getStyle())) {
            style.append("list-style-type: " + parameters.getStyle() + SEMICOLUMN);
        }
        if (!"".equals(parameters.getIndent())) {
            style.append("padding-inline-start: " + parameters.getIndent() + SEMICOLUMN);
        }
        if (!"".equals(style.toString())) {
            listParameters = Collections.singletonMap("style", style.toString());
        }
        for (Block block : body) {
            for (Block b : block.getBlocks((BlockMatcher)new AnyBlockMatcher(), Block.Axes.DESCENDANT)) {
                HeaderBlock header;
                if (!(b instanceof HeaderBlock) || this.filterHeader(header = (HeaderBlock)b, parameters)) continue;
                int level = header.getLevel().getAsInt() + levelOffset;
                this.getNewLevel(level, levels, listParameters).addChild((Block)new ListItemBlock(Arrays.asList(this.getOutline(level, outlineLevels, parameters), new SpaceBlock(), this.getHeaderLink(header))));
            }
        }
        if (levels.size() > 0) {
            return (Block)levels.get(0);
        }
        return new WordBlock("");
    }

    private LinkBlock getHeaderLink(HeaderBlock headerBlock) {
        String idParameter = headerBlock.getParameter("id");
        if (idParameter == null) {
            idParameter = headerBlock.getId();
        }
        ConfluenceTocZoneBlockFilter confluenceTocZoneBlockFilter = new ConfluenceTocZoneBlockFilter(this.plainTextParser, this.linkLabelGenerator);
        return new LinkBlock(confluenceTocZoneBlockFilter.generateLabel(headerBlock), new ResourceReference("#" + idParameter, ResourceType.URL), false);
    }

    private int getLevelOffset(List<Block> body, ConfluenceTocZoneMacroParameters parameters) {
        int minLevel = Integer.MAX_VALUE;
        for (Block block : body) {
            for (Block b : block.getBlocks((BlockMatcher)new AnyBlockMatcher(), Block.Axes.DESCENDANT)) {
                HeaderBlock header;
                if (!(b instanceof HeaderBlock) || this.filterHeader(header = (HeaderBlock)b, parameters)) continue;
                int level = header.getLevel().getAsInt();
                minLevel = Integer.min(level, minLevel);
            }
        }
        return -minLevel;
    }

    private boolean filterHeader(HeaderBlock header, ConfluenceTocZoneMacroParameters parameters) {
        int level = header.getLevel().getAsInt();
        if (level < parameters.getMinLevel()) {
            return true;
        }
        if (level > parameters.getMaxLevel()) {
            return true;
        }
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.plainTextRenderer.render((Block)header, (WikiPrinter)printer);
        Pattern includeRegex = Pattern.compile(parameters.getInclude());
        if (!includeRegex.matcher(printer.toString()).find()) {
            return true;
        }
        Pattern excludeRegex = Pattern.compile(parameters.getExclude());
        return excludeRegex.matcher(printer.toString()).find();
    }

    private Block getOutline(int level, List<Integer> levels, ConfluenceTocZoneMacroParameters parameters) {
        int i;
        StringBuilder outline = new StringBuilder("");
        for (i = levels.size() - 1; i > level; --i) {
            levels.remove(i);
        }
        for (i = levels.size() - 1; i < level; ++i) {
            levels.add(levels.size() + 1 != level ? 0 : 1);
        }
        levels.set(level, levels.get(level) + 1);
        if (parameters.isOutline().booleanValue()) {
            outline.append(levels.get(0));
            for (i = 1; i <= level; ++i) {
                outline.append(".");
                outline.append(levels.get(i));
            }
        }
        return new WordBlock(outline.toString());
    }

    private ListBLock getNewLevel(int level, List<ListBLock> levels, Map<String, String> listParameters) {
        int i;
        if (levels.isEmpty()) {
            levels.add((ListBLock)new BulletedListBlock(new ArrayList(), listParameters));
        }
        for (i = levels.size() - 1; i > level; --i) {
            levels.remove(i);
        }
        for (i = levels.size() - 1; i < level; ++i) {
            levels.add((ListBLock)new BulletedListBlock(new ArrayList(), listParameters));
            levels.get(i).addChild((Block)levels.get(i + 1));
        }
        return levels.get(level);
    }

    private List<Block> parseContent(String content, MacroTransformationContext context) throws MacroExecutionException {
        List children = this.contentParser.parse(content, context, false, context.isInline()).getChildren();
        return Collections.singletonList(new MetaDataBlock(children, this.getNonGeneratedContentMetaData()));
    }

    private List<Block> parseReadOnlyContent(String content, MacroTransformationContext context) throws MacroExecutionException {
        return this.contentParser.parse(content, context, true, true).getChildren();
    }
}

