/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.confluence;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.confluence.ConfluenceOutgoingLinksMacroParameters;
import com.xwiki.macros.confluence.internal.ConfluenceSpaceUtils;
import com.xwiki.macros.confluence.internal.XDOMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.AnyBlockMatcher;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.stability.Unstable;

@Component
@Named(value="confluence_outgoing-links")
@Singleton
@Unstable
public class ConfluenceOutgoingLinksMacro
extends AbstractProMacro<ConfluenceOutgoingLinksMacroParameters> {
    @Inject
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private ConfluenceSpaceUtils confluenceSpaceUtils;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private AttachmentReferenceResolver<String> attachmentReferenceResolver;

    public ConfluenceOutgoingLinksMacro() {
        super("Confluence Outgoing Links", "Confluence bridge macro for outgoing-links.", ConfluenceOutgoingLinksMacroParameters.class);
    }

    public List<Block> internalExecute(ConfluenceOutgoingLinksMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XWikiDocument document = ((XWikiContext)this.contextProvider.get()).getDoc();
        LinkedHashSet<LinkBlock> links = new LinkedHashSet<LinkBlock>();
        try {
            String spacesStr = parameters.getSpaces();
            String[] spaces = spacesStr == null || spacesStr.isEmpty() ? null : spacesStr.split(",");
            this.browseXDOM((Block)document.getXDOM(), document.getSyntax(), links, spaces);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Could not compute outgoing links", (Throwable)e);
        }
        if (links.isEmpty()) {
            return Collections.singletonList(new MacroBlock("info", Collections.emptyMap(), this.localizationManager.getTranslationPlain("rendering.macro.confluence_outgoinglinks.noresults", new Object[0]), context.isInline()));
        }
        return Collections.singletonList(new BulletedListBlock(new ArrayList(links.stream().map(link -> new ListItemBlock(Collections.singletonList(link))).collect(Collectors.toList()))));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    private void browseXDOM(Block block, Syntax syntaxId, Set<LinkBlock> links, String[] spaces) throws ComponentLookupException {
        for (Block b : block.getBlocks((BlockMatcher)new AnyBlockMatcher(), Block.Axes.DESCENDANT)) {
            if (b instanceof MacroBlock) {
                XDOM content = XDOMUtils.getMacroXDOM((ComponentManager)this.componentManagerProvider.get(), (MacroBlock)b, syntaxId);
                if (content == null) continue;
                this.browseXDOM((Block)content, syntaxId, links, spaces);
                continue;
            }
            if (b instanceof LinkBlock) {
                this.maybeAddLink(links, spaces, (LinkBlock)b);
            }
            this.browseXDOM(b, syntaxId, links, spaces);
        }
    }

    private void maybeAddLink(Set<LinkBlock> links, String[] spaces, LinkBlock b) {
        if (spaces == null) {
            links.add(b);
        } else {
            ResourceReference reference = b.getReference();
            if (reference.getType() == ResourceType.DOCUMENT) {
                DocumentReference currentDocRef = ((XWikiContext)this.contextProvider.get()).getDoc().getDocumentReference();
                DocumentReference ref = this.documentReferenceResolver.resolve((Object)reference.getReference(), new Object[]{currentDocRef});
                if (this.isReferenceInSpaces(spaces, (EntityReference)ref)) {
                    links.add(b);
                }
            } else if (reference.getType() == ResourceType.ATTACHMENT) {
                DocumentReference currentDocRef = ((XWikiContext)this.contextProvider.get()).getDoc().getDocumentReference();
                AttachmentReference ref = this.attachmentReferenceResolver.resolve((Object)reference.getReference(), new Object[]{currentDocRef});
                if (this.isReferenceInSpaces(spaces, (EntityReference)ref)) {
                    links.add(b);
                }
            }
        }
    }

    private boolean isReferenceInSpaces(String[] spaces, EntityReference reference) {
        for (String space : spaces) {
            EntityReference spaceRef = this.confluenceSpaceUtils.getSloppySpace(space);
            if (spaceRef == null || !reference.hasParent(spaceRef)) continue;
            return true;
        }
        return false;
    }
}

