/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.confluence.internal;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;

public final class XDOMUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XDOMUtils.class);

    private XDOMUtils() {
    }

    private static XDOM parse(ComponentManager componentManager, String text, String syntaxId) {
        XDOM result;
        try {
            Parser parser = (Parser)componentManager.getInstance(Parser.class, syntaxId);
            result = parser.parse((Reader)new StringReader(text));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static XDOM getMacroXDOM(ComponentManager componentManager, MacroBlock macroBlock, String syntaxId) throws ComponentLookupException {
        if (componentManager.hasComponent(Macro.class, macroBlock.getId())) {
            ContentDescriptor macroContentDescriptor = ((Macro)componentManager.getInstance(Macro.class, macroBlock.getId())).getDescriptor().getContentDescriptor();
            if (macroContentDescriptor != null && macroContentDescriptor.getType().equals(Block.LIST_BLOCK_TYPE) && StringUtils.isNotBlank((CharSequence)macroBlock.getContent())) {
                return XDOMUtils.parse(componentManager, macroBlock.getContent(), syntaxId);
            }
        } else if (StringUtils.isNotBlank((CharSequence)macroBlock.getContent())) {
            LOGGER.debug("Calling parse on unknown macro [{}] with syntax [{}]", (Object)macroBlock.getId(), (Object)syntaxId);
            return XDOMUtils.parse(componentManager, macroBlock.getContent(), syntaxId);
        }
        return null;
    }

    public static XDOM getMacroXDOM(ComponentManager componentManager, MacroBlock macroBlock, Syntax syntaxId) throws ComponentLookupException {
        return XDOMUtils.getMacroXDOM(componentManager, macroBlock, syntaxId.toIdString());
    }
}

