/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.confluence;

import com.xpn.xwiki.api.Document;
import com.xwiki.macros.confluence.internal.ConfluenceSpaceUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.resolvers.ConfluenceResolverException;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceResolver;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Singleton
@Named(value="confluence.spaces")
@Unstable
public class ConfluenceSpacesScriptService
implements ScriptService {
    @Inject
    private ConfluenceSpaceUtils confluenceSpaceUtils;
    @Inject
    private ConfluenceSpaceResolver confluenceSpaceResolver;
    @Inject
    private EntityReferenceResolver<String> resolver;

    public EntityReference getConfluenceSpace(EntityReference documentReference) throws ConfluenceResolverException {
        return this.confluenceSpaceResolver.getSpace(documentReference);
    }

    public EntityReference getConfluenceSpace(String documentReference) throws ConfluenceResolverException {
        return this.getConfluenceSpace(this.resolver.resolve((Object)documentReference, EntityType.DOCUMENT, new Object[0]));
    }

    public EntityReference getConfluenceSpace(Document document) throws ConfluenceResolverException {
        return this.getConfluenceSpace((EntityReference)document.getDocumentReference());
    }

    public EntityReference getSloppySpace(String spaceKeyOrRef) {
        return this.confluenceSpaceUtils.getSloppySpace(spaceKeyOrRef);
    }
}

