/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.confluence;

import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.confluence.ConfluenceJiraChartMacroParameters;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.stability.Unstable;

@Component
@Named(value="confluence_jirachart")
@Singleton
@Unstable
public class ConfluenceJiraChartMacro
extends AbstractProMacro<ConfluenceJiraChartMacroParameters> {
    private static final Map<String, String> VERSION_LABEL_MAP = Map.of("all", "ALL", "major", "ONLY_MAJOR", "none", "NONE");
    private static final String CHART_PARAM_STATUSES = "statuses";
    private static final String CHART_PARAM_ALL_FIXFOR = "allFixfor";
    private static final String CHART_PARAM_ASSIGNEES = "assignees";
    private static final String CHART_PARAM_PRIORITIES = "priorities";
    private static final String CHART_PARAM_COMPONENTS = "components";
    private static final String CHART_PARAM_ISSUETYPE = "issuetype";
    private static final String CHART_PARAM_STATUS = "STATUS";
    private static final String CHART_PARAM_FIX_VERSION = "FIX_VERSION";
    private static final String CHART_PARAM_ASSIGNEE = "ASSIGNEE";
    private static final String CHART_PARAM_PRIORITY = "PRIORITY";
    private static final String CHART_PARAM_COMPONENT = "COMPONENT";
    private static final Map<String, String> PIE_CHART_TYPE_PARAM = Map.of("statuses", "STATUS", "allFixfor", "FIX_VERSION", "assignees", "ASSIGNEE", "priorities", "PRIORITY", "components", "COMPONENT", "issuetype", "ISSUE_TYPE");
    private static final Map<String, String> BI_DIMENSIONAL_GRID_CHART_AXIS_PARAM = Map.of("assignees", "ASSIGNEE", "reporter", "REPORTER", "statuses", "STATUS", "allFixfor", "FIX_VERSION", "components", "COMPONENT", "priorities", "PRIORITY", "issuetype", "TYPE");
    private static final Pattern JQL_FILTER_PATTERN = Pattern.compile("^filter\\s*=\\s*(\\d+)$");
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String PIE = "pie";
    private static final String CREATEDVSRESOLVED = "createdvsresolved";
    private static final String TWODIMENSIONAL = "twodimensional";

    public ConfluenceJiraChartMacro() {
        super("Confluence Jira chart", "Confluence bridge macro for jira chart.", ConfluenceJiraChartMacroParameters.class);
    }

    public boolean supportsInlineMode() {
        return false;
    }

    protected List<Block> internalExecute(ConfluenceJiraChartMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String macroName;
        HashMap<String, String> jiraChartMacroParameters = new HashMap<String, String>();
        if (!StringUtils.isNotEmpty((CharSequence)parameters.getServer())) {
            throw new MacroExecutionException("server ID parameter is required");
        }
        jiraChartMacroParameters.put("id", parameters.getServer());
        if (!StringUtils.isNotEmpty((CharSequence)parameters.getJql())) {
            throw new MacroExecutionException("jql parameter is required");
        }
        String jqlValue = URLDecoder.decode(parameters.getJql(), StandardCharsets.UTF_8);
        Matcher jqlFilterMatcher = JQL_FILTER_PATTERN.matcher(jqlValue);
        if (jqlFilterMatcher.find()) {
            jiraChartMacroParameters.put("filterId", "filter-" + jqlFilterMatcher.group(1));
        } else {
            jiraChartMacroParameters.put("query", jqlValue);
        }
        switch (parameters.getChartType()) {
            case "pie": {
                macroName = "jiraPieChart";
                ConfluenceJiraChartMacro.handlePieChartParameter(parameters, jiraChartMacroParameters);
                break;
            }
            case "createdvsresolved": {
                macroName = "jiraCreatedVsResolvedChart";
                ConfluenceJiraChartMacro.handleCreatedVsResolvedChartParameter(parameters, jiraChartMacroParameters);
                break;
            }
            case "twodimensional": {
                macroName = "jiraBiDimensionalGridChart";
                ConfluenceJiraChartMacro.handleTwoDimensionalChartParameter(parameters, jiraChartMacroParameters);
                break;
            }
            default: {
                throw new MacroExecutionException("Invalid chart type " + parameters.getChartType());
            }
        }
        return List.of(new MacroBlock(macroName, jiraChartMacroParameters, false));
    }

    private static void handlePieChartParameter(ConfluenceJiraChartMacroParameters parameters, Map<String, String> jiraChartMacroParameters) throws MacroExecutionException {
        if (StringUtils.isNotEmpty((CharSequence)parameters.getStatType())) {
            if (!PIE_CHART_TYPE_PARAM.containsKey(parameters.getStatType())) {
                throw new MacroExecutionException(String.format("State type parameter value '%s' is not supported", parameters.getStatType()));
            }
            jiraChartMacroParameters.put("type", PIE_CHART_TYPE_PARAM.get(parameters.getStatType()));
        }
    }

    private static void handleCreatedVsResolvedChartParameter(ConfluenceJiraChartMacroParameters parameters, Map<String, String> jiraChartMacroParameters) {
        if (StringUtils.isNotEmpty((CharSequence)parameters.getDaysprevious())) {
            jiraChartMacroParameters.put("daysPreviously", parameters.getDaysprevious());
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getPeriodName())) {
            jiraChartMacroParameters.put("period", parameters.getPeriodName().toUpperCase());
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getIsCumulative())) {
            String isCumulative = TRUE.equalsIgnoreCase(parameters.getIsCumulative()) ? FALSE : TRUE;
            jiraChartMacroParameters.put("count", isCumulative);
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getShowUnresolvedTrend())) {
            jiraChartMacroParameters.put("displayTrend", parameters.getShowUnresolvedTrend());
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getVersionLabel())) {
            String versionLabel = VERSION_LABEL_MAP.getOrDefault(parameters.getVersionLabel(), parameters.getVersionLabel());
            jiraChartMacroParameters.put("displayVersion", versionLabel);
        }
    }

    private static void handleTwoDimensionalChartParameter(ConfluenceJiraChartMacroParameters parameters, Map<String, String> jiraChartMacroParameters) throws MacroExecutionException {
        if (StringUtils.isNotEmpty((CharSequence)parameters.getXstattype())) {
            if (!BI_DIMENSIONAL_GRID_CHART_AXIS_PARAM.containsKey(parameters.getXstattype())) {
                throw new MacroExecutionException(String.format("x stat type parameter value '%s' is not supported", parameters.getXstattype()));
            }
            jiraChartMacroParameters.put("xAxisField", BI_DIMENSIONAL_GRID_CHART_AXIS_PARAM.get(parameters.getXstattype()));
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getYstattype())) {
            if (!BI_DIMENSIONAL_GRID_CHART_AXIS_PARAM.containsKey(parameters.getYstattype())) {
                throw new MacroExecutionException(String.format("y stat type parameter value '%s' is not supported", parameters.getYstattype()));
            }
            jiraChartMacroParameters.put("yAxisField", BI_DIMENSIONAL_GRID_CHART_AXIS_PARAM.get(parameters.getYstattype()));
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.getNumberToShow())) {
            jiraChartMacroParameters.put("numberOfResults", parameters.getNumberToShow());
        }
    }
}

