/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.confluence;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.macros.confluence.internal.XDOMUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.TableCellBlock;
import org.xwiki.rendering.block.TableRowBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Singleton
@Named(value="confluence.details")
@Unstable
public class ConfluenceDetailsScriptService
implements ScriptService {
    private static final BlockMatcher CELL_MATCHER = new ClassBlockMatcher(TableCellBlock.class);
    private static final BlockMatcher ROW_MATCHER = new ClassBlockMatcher(TableRowBlock.class);
    private static final ClassBlockMatcher MACRO_MATCHER = new ClassBlockMatcher(MacroBlock.class);
    private static final String ID = "id";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private EntityReferenceResolver<String> resolver;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextRenderer;
    @Inject
    @Named(value="xwiki/2.1")
    private BlockRenderer xwikiSyntaxRenderer;
    @Inject
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;

    private List<XDOM> findDetailsMacros(XDOM xdom, String syntaxId, String id) {
        ArrayList<XDOM> results = new ArrayList<XDOM>(1);
        List macros = xdom.getBlocks((BlockMatcher)MACRO_MATCHER, Block.Axes.DESCENDANT_OR_SELF);
        for (MacroBlock macroBlock : macros) {
            try {
                if (StringUtils.equals((CharSequence)"confluence_details", (CharSequence)macroBlock.getId())) {
                    if (!StringUtils.isBlank((CharSequence)id) && !StringUtils.equals((CharSequence)id, (CharSequence)StringUtils.defaultString((String)macroBlock.getParameter(ID)))) continue;
                    results.add(XDOMUtils.getMacroXDOM((ComponentManager)this.componentManagerProvider.get(), macroBlock, syntaxId));
                    continue;
                }
                XDOM macroXDOM = XDOMUtils.getMacroXDOM((ComponentManager)this.componentManagerProvider.get(), macroBlock, syntaxId);
                if (macroXDOM == null) continue;
                results.addAll(this.findDetailsMacros(macroXDOM, syntaxId, id));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Component lookup error trying to find the confluence_details macro", (Throwable)e);
            }
        }
        return results;
    }

    public List<List<String>> getDetails(String id, String headingsParam, List<Map<String, Object>> results) {
        return this.getDetails(id, headingsParam, results, "", false);
    }

    public List<List<String>> getDetails(String id, String headingsParam, List<Map<String, Object>> results, String sortBy, boolean reverseSort) {
        ArrayList<String> headings = this.parseHeadings(headingsParam);
        ArrayList<String> columns = headings.isEmpty() ? new ArrayList<String>() : headings;
        ArrayList<String> columnsLower = headings.isEmpty() ? new ArrayList<String>() : headings.stream().map(String::toLowerCase).collect(Collectors.toList());
        ArrayList<List<String>> rows = new ArrayList<List<String>>(results.size() + 1);
        for (Map<String, Object> response : results) {
            XWikiDocument doc;
            String fullName = response.get("wiki").toString() + ":" + response.get("fullname").toString();
            EntityReference docRef = this.resolver.resolve((Object)fullName, EntityType.DOCUMENT, new Object[0]);
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            try {
                doc = context.getWiki().getDocument(docRef, context);
            }
            catch (XWikiException e) {
                this.logger.error("Could not get the document", (Throwable)e);
                continue;
            }
            List<XDOM> details = this.findDetailsMacros(doc.getXDOM(), doc.getSyntax().toIdString(), StringUtils.defaultString((String)id));
            if (CollectionUtils.isEmpty(details)) continue;
            List<String> row = null;
            for (XDOM detailMacro : details) {
                row = this.getRow(detailMacro, headings, columns, columnsLower, doc.getSyntax(), row);
            }
            if (row == null) continue;
            row.add(0, fullName);
            rows.add(row);
        }
        ConfluenceDetailsScriptService.maybeSort(sortBy, reverseSort, columnsLower, rows);
        rows.add(0, columns);
        return rows;
    }

    private static void maybeSort(String sortBy, boolean reverseSort, List<String> columnsLower, List<List<String>> rows) {
        int i;
        boolean alreadyReversedIfNeeded = false;
        if (StringUtils.isNotEmpty((CharSequence)sortBy) && (i = columnsLower.indexOf(sortBy.toLowerCase())) != -1) {
            alreadyReversedIfNeeded = true;
            rows.sort((l1, l2) -> {
                String v1 = i + 1 < l1.size() ? (String)l1.get(i + 1) : "";
                String v2 = i + 1 < l2.size() ? (String)l2.get(i + 1) : "";
                int r = Objects.compare(v1, v2, Comparator.comparing(String::toString));
                if (reverseSort) {
                    return -r;
                }
                return r;
            });
        }
        if (reverseSort && !alreadyReversedIfNeeded) {
            Collections.reverse(rows);
        }
    }

    private List<TableRowBlock> findRows(XDOM xdom, Syntax syntax) {
        List<TableRowBlock> xdomRows = xdom.getBlocks(ROW_MATCHER, Block.Axes.DESCENDANT_OR_SELF);
        if (!xdomRows.isEmpty()) {
            return xdomRows;
        }
        List macroBlocks = xdom.getBlocks((BlockMatcher)MACRO_MATCHER, Block.Axes.DESCENDANT);
        for (MacroBlock macroBlock : macroBlocks) {
            XDOM macroContent;
            try {
                macroContent = XDOMUtils.getMacroXDOM((ComponentManager)this.componentManagerProvider.get(), macroBlock, syntax);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to parse macro content for [{}]", (Object)macroBlock.getId(), (Object)e);
                continue;
            }
            if (macroContent == null || (xdomRows = this.findRows(macroContent, syntax)).isEmpty()) continue;
            return xdomRows;
        }
        return Collections.emptyList();
    }

    private List<String> getRow(XDOM xdomDetails, List<String> headings, List<String> columns, List<String> columnsLower, Syntax syntax, List<String> row) {
        List<TableRowBlock> xdomRows = this.findRows(xdomDetails, syntax);
        ArrayList<String> r = row == null ? new ArrayList<String>(1 + (headings.isEmpty() ? Math.max(columns.size(), xdomRows.size()) : headings.size())) : row;
        for (TableRowBlock xdomRow : xdomRows) {
            List cells = xdomRow.getBlocks(CELL_MATCHER, Block.Axes.DESCENDANT_OR_SELF);
            if (cells.size() < 2) continue;
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.plainTextRenderer.render((Block)cells.get(0), (WikiPrinter)printer);
            String key = printer.toString().trim();
            printer.clear();
            this.xwikiSyntaxRenderer.render((Collection)((TableCellBlock)cells.get(1)).getChildren(), (WikiPrinter)printer);
            String value = printer.toString().trim();
            String keyLower = key.toLowerCase();
            int index = columnsLower.indexOf(keyLower);
            if (index == -1) {
                if (!headings.isEmpty()) continue;
                index = columns.size();
                columns.add(key);
                columnsLower.add(keyLower);
            }
            while (index >= r.size()) {
                r.add("");
            }
            r.set(index, value);
        }
        return r;
    }

    private List<String> parseHeadings(String headingsParam) {
        if (StringUtils.isEmpty((CharSequence)headingsParam)) {
            return Collections.emptyList();
        }
        ArrayList<String> headings = new ArrayList<String>(StringUtils.countMatches((CharSequence)headingsParam, (char)','));
        int len = headingsParam.length();
        StringBuilder heading = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = headingsParam.charAt(i);
            if (c == '\"') {
                ++i;
                while (i < len && (c = headingsParam.charAt(i)) != '\"') {
                    if (c == '\\') {
                        c = headingsParam.charAt(++i);
                    }
                    heading.append(c);
                    ++i;
                }
                continue;
            }
            if (c == ',') {
                headings.add(heading.toString().trim());
                heading.setLength(0);
                continue;
            }
            heading.append(c);
        }
        if (heading.length() > 0) {
            headings.add(heading.toString().trim());
        }
        return headings;
    }
}

