/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.showhideif.macro;

import com.xwiki.macros.showhideif.internal.macro.AbstractShowHideIfMacro;
import com.xwiki.macros.showhideif.macro.ShowHideIfMacroParameters;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="show-if")
@Singleton
public class ShowIfMacro
extends AbstractShowHideIfMacro {
    private static final String NAME = "Show if";
    private static final String DESCRIPTION = "Show the content of this macro if the condition set through the parameters is met.";

    public ShowIfMacro() {
        super(NAME, DESCRIPTION);
    }

    @Override
    protected List<Block> internalExecute(ShowHideIfMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        SyntaxType targetSyntaxType;
        Syntax syntax = context.getTransformationContext().getTargetSyntax();
        SyntaxType syntaxType = targetSyntaxType = syntax == null ? null : syntax.getType();
        if (SyntaxType.ANNOTATED_HTML.equals((Object)targetSyntaxType) || SyntaxType.ANNOTATED_XHTML.equals((Object)targetSyntaxType)) {
            List children = this.contentParser.parse(content, context, false, context.isInline()).getChildren();
            return Collections.singletonList(new MetaDataBlock(children, this.getNonGeneratedContentMetaData()));
        }
        LinkedList<Block> result = new LinkedList<Block>();
        this.maybeGetUnsupportedParameterErrorBlock(context).ifPresent(result::add);
        if (this.doesMatch(parameters)) {
            List children = this.contentParser.parse(content, context, false, context.isInline()).getChildren();
            result.add((Block)new MetaDataBlock(children, this.getNonGeneratedContentMetaData()));
        }
        return result;
    }
}

