/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.showhideif.internal.macro;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.internal.grouplist.GroupReferenceList;
import com.xwiki.macros.internal.userlist.UserReferenceList;
import com.xwiki.macros.showhideif.macro.ShowHideIfMacroParameters;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections.CollectionUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.properties.BeanDescriptor;
import org.xwiki.properties.PropertyDescriptor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.script.RenderingScriptService;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.script.service.ScriptService;
import org.xwiki.user.group.GroupException;
import org.xwiki.user.group.GroupManager;
import org.xwiki.user.group.WikiTarget;

public abstract class AbstractShowHideIfMacro
extends AbstractProMacro<ShowHideIfMacroParameters> {
    private static final String CONTENT_DESCRIPTION = "The content to be displayed conditionally.";
    @Inject
    protected MacroContentParser contentParser;
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;
    @Inject
    private GroupManager groupManager;
    @Inject
    @Named(value="rendering")
    private ScriptService renderingScriptService;

    public AbstractShowHideIfMacro(String name, String description) {
        super(name, description, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false, Block.LIST_BLOCK_TYPE), ShowHideIfMacroParameters.class);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected boolean doesMatch(ShowHideIfMacroParameters parameters) throws MacroExecutionException {
        boolean matchAnyRes = false;
        boolean matchAllRes = true;
        XWikiContext xcontext = (XWikiContext)this.xwikiContextProvider.get();
        DocumentReference userReference = xcontext.getUserReference();
        ShowHideIfMacroParameters.AuthType authTypeParam = parameters.getAuthenticationType();
        if (userReference != null) {
            GroupReferenceList groupsParam;
            UserReferenceList usersParam = parameters.getUsers();
            if (!CollectionUtils.isEmpty((Collection)usersParam)) {
                boolean res = usersParam.stream().anyMatch(u -> u.equals((Object)userReference));
                matchAnyRes |= res;
                matchAllRes &= res;
            }
            if (!CollectionUtils.isEmpty((Collection)(groupsParam = parameters.getGroups()))) {
                Collection userGroupsMember = null;
                try {
                    userGroupsMember = this.groupManager.getGroups(userReference, (Object)WikiTarget.ALL, true);
                }
                catch (GroupException e) {
                    throw new MacroExecutionException("Can't check for group member", (Throwable)e);
                }
                boolean res = !CollectionUtils.intersection((Collection)userGroupsMember, (Collection)groupsParam).isEmpty();
                matchAnyRes |= res;
                matchAllRes &= res;
            }
        }
        switch (authTypeParam) {
            case AUTHENTICATED: {
                if (userReference == null) {
                    matchAllRes = false;
                    break;
                }
                matchAnyRes = true;
                break;
            }
            case ANONYMOUS: {
                if (userReference == null) {
                    matchAnyRes = true;
                    break;
                }
                matchAllRes = false;
                break;
            }
        }
        if (parameters.getDisplayType() != null && parameters.getDisplayType() != ShowHideIfMacroParameters.DisplayType.NONE) {
            boolean isExportPrintable = "export".equalsIgnoreCase(xcontext.getAction());
            switch (parameters.getDisplayType()) {
                case DEFAULT: {
                    if (isExportPrintable) {
                        matchAllRes = false;
                        break;
                    }
                    matchAnyRes = true;
                    break;
                }
                case PRINTABLE: {
                    if (isExportPrintable) {
                        matchAnyRes = true;
                        break;
                    }
                    matchAllRes = false;
                    break;
                }
            }
        }
        return parameters.getMatchUsing() == ShowHideIfMacroParameters.Matcher.ANY && matchAnyRes || parameters.getMatchUsing() == ShowHideIfMacroParameters.Matcher.ALL && matchAllRes;
    }

    protected Optional<Block> maybeGetUnsupportedParameterErrorBlock(MacroTransformationContext context) {
        String unhandledParametersPrefix = "confluence_";
        List<String> parametersWhiteList = List.of("atlassian-macro-output-type");
        Map allParameters = context.getCurrentMacroBlock().getParameters();
        Set parameterNames = allParameters.keySet();
        BeanDescriptor beanDescriptor = this.beanManager.getBeanDescriptor(ShowHideIfMacroParameters.class);
        List beanPropertiesIds = beanDescriptor.getProperties().stream().map(PropertyDescriptor::getId).collect(Collectors.toList());
        LinkedList<String> unsupportedParameters = new LinkedList<String>();
        for (String parameterName : parameterNames) {
            if (beanPropertiesIds.contains(parameterName) || parametersWhiteList.contains(parameterName) || parameterName.startsWith(unhandledParametersPrefix)) continue;
            unsupportedParameters.add(parameterName);
        }
        if (!unsupportedParameters.isEmpty()) {
            return Optional.of(new MacroBlock("error", Collections.emptyMap(), ((RenderingScriptService)this.renderingScriptService).escape("Unsupported parameter(s) for macro " + context.getCurrentMacroBlock().getId() + ": " + String.join((CharSequence)", ", unsupportedParameters) + ".", context.getSyntax()) + " Due to this, the macro might have unexpected results.", false));
        }
        return Optional.empty();
    }
}

