/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.script;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Named(value="taglist")
@Singleton
@Unstable
public class TagListScriptService
implements ScriptService {
    private static final String DIGIT_BLOCK = "DIGITS";
    private static final String SEPARATOR = ",";
    private static final String QUOTES = "'";

    public String parseSpaces(String userInput) {
        StringBuilder builder = new StringBuilder();
        String[] spaces = userInput.split(SEPARATOR);
        for (int i = 0; i < spaces.length; ++i) {
            String space = spaces[i];
            builder.append(QUOTES);
            builder.append(space.trim());
            builder.append(QUOTES);
            if (i >= spaces.length - 1) continue;
            builder.append(SEPARATOR);
        }
        return builder.toString();
    }

    public Map<String, List<String>> getBins(List<String> tags) {
        TreeMap<String, List<String>> finalBins = new TreeMap<String, List<String>>();
        StringBuilder key = new StringBuilder();
        char binSeparator = '-';
        int totalEntries = tags.size();
        int binLimit = (int)(2L * Math.round(Math.pow(totalEntries, 0.3333333333333333)));
        char firstCh = '\uffff';
        char previousCh = '\uffff';
        ArrayList<String> binTags = new ArrayList<String>();
        int current = 0;
        for (int start = 0; start < tags.size(); ++start) {
            if (!Character.isLetterOrDigit(tags.get(start).charAt(0))) continue;
            firstCh = tags.get(start).charAt(0);
            break;
        }
        for (int i = start; i < tags.size(); ++i) {
            char currentCh = tags.get(i).charAt(0);
            if (!Character.isLetterOrDigit(currentCh)) continue;
            String tag = tags.get(i);
            if (this.makeBin(current, binLimit, previousCh, currentCh)) {
                current = 0;
                this.addBin(finalBins, key, binSeparator, firstCh, previousCh, binTags);
                binTags = new ArrayList();
                firstCh = currentCh;
            }
            binTags.add(tag);
            previousCh = currentCh;
            ++current;
        }
        this.addBin(finalBins, key, binSeparator, firstCh, previousCh, binTags);
        return finalBins;
    }

    public String getBinName(char ch) {
        if (Character.isLetter(ch)) {
            return Character.UnicodeBlock.of(ch).toString();
        }
        if (Character.isDigit(ch)) {
            return DIGIT_BLOCK;
        }
        return null;
    }

    private boolean makeBin(int current, int binLimit, char previousCh, char currentCh) {
        return current >= binLimit && previousCh != currentCh || previousCh != '\uffff' && !this.getBinName(currentCh).equals(this.getBinName(previousCh));
    }

    private void addBin(Map<String, List<String>> finalBins, StringBuilder key, char binSeparator, char firstCh, char previousCh, List<String> binTags) {
        if (binTags.isEmpty()) {
            return;
        }
        key.setLength(0);
        key.append(Character.toUpperCase(firstCh));
        if (previousCh != firstCh) {
            key.append(binSeparator);
            key.append(Character.toUpperCase(previousCh));
        }
        finalBins.put(key.toString(), binTags);
    }
}

