/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros.excerptinclude.internal.macro;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.macros.AbstractProMacro;
import com.xwiki.macros.excerptinclude.macro.ExcerptIncludeMacroParameters;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="excerpt-include")
@Singleton
@Unstable
public class ExcerptIncludeMacro
extends AbstractProMacro<ExcerptIncludeMacroParameters> {
    static final String EXCERPT_INCLUDE = "excerpt-include";
    private static final String NAME = "name";
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private ContextualAuthorizationManager contextualAuthorization;
    @Inject
    @Named(value="content")
    private DocumentDisplayer contentDisplayer;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private MacroManager macroManager;
    @Inject
    private Provider<ComponentManager> cmProvider;
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    public ExcerptIncludeMacro() {
        super("Excerpt include", "Includes excerpts from other documents into the current page. The included pages need to contain the simple `excerpt` macro.", ExcerptIncludeMacroParameters.class);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    @Override
    protected List<Block> internalExecute(ExcerptIncludeMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XWikiDocument document = this.getReferencedDocument(parameters);
        DocumentReference documentReference = document.getDocumentReference();
        if (this.recursionDetected(documentReference, parameters.getName(), context)) {
            return Collections.singletonList(this.getErrorXDOM(this.localizationManager.getTranslationPlain("rendering.macro.excerptinclude.recursiondetected", new Object[]{documentReference}), context));
        }
        boolean inline = context.isInline() || parameters.isInline();
        XDOM displayContent = document.isNew() ? this.getErrorXDOM(this.localizationManager.getTranslationPlain("rendering.macro.excerptinclude.referenceexcerptnotfound", new Object[]{documentReference}), context) : this.getExcerpt(parameters.getName(), document, context, inline);
        return inline || parameters.isNopanel() ? Collections.singletonList(displayContent) : this.renderPanel(document, displayContent, documentReference);
    }

    private boolean recursionDetected(DocumentReference includedDoc, String name, MacroTransformationContext context) {
        MacroBlock currentMacroBlock = context.getCurrentMacroBlock();
        return this.recursionDetected(includedDoc, name, currentMacroBlock.getParent());
    }

    private boolean recursionDetected(DocumentReference includedDoc, String name, Block parentBlock) {
        if (parentBlock == null) {
            return false;
        }
        if (this.isSameIncludeExcerpt(includedDoc, name, parentBlock)) {
            return true;
        }
        return this.recursionDetected(includedDoc, name, parentBlock.getParent());
    }

    private boolean isSameIncludeExcerpt(DocumentReference includedDoc, String name, Block parentBlock) {
        if (!(parentBlock instanceof MacroMarkerBlock)) {
            return false;
        }
        MacroMarkerBlock parentMacro = (MacroMarkerBlock)parentBlock;
        if (EXCERPT_INCLUDE.equals(parentMacro.getId()) && StringUtils.defaultString((String)parentMacro.getParameter(NAME)).equals(name)) {
            String serializedRef = parentMacro.getParameter("0");
            DocumentReference ref = StringUtils.isEmpty((CharSequence)serializedRef) ? ((XWikiContext)this.contextProvider.get()).getDoc().getDocumentReference() : this.documentReferenceResolver.resolve((Object)serializedRef, new Object[0]);
            return ref.equals((Object)includedDoc);
        }
        return false;
    }

    private XWikiDocument getReferencedDocument(ExcerptIncludeMacroParameters parameters) throws MacroExecutionException {
        DocumentReference reference = parameters.getReference();
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        try {
            return reference == null ? xcontext.getDoc() : xcontext.getWiki().getDocument(reference, xcontext);
        }
        catch (XWikiException e) {
            throw new MacroExecutionException(String.format("Failed to get document for reference [%s]", reference), (Throwable)e);
        }
    }

    private List<Block> renderPanel(XWikiDocument document, XDOM displayContent, DocumentReference reference) {
        HashMap<String, String> panelParameters = new HashMap<String, String>(1);
        panelParameters.put("classes", "macro-excerpt-include");
        panelParameters.put("title", document.getTitle());
        MacroBlock panel = new MacroBlock("panel", panelParameters, this.renderExcerptContent(displayContent), false);
        String source = (String)this.entityReferenceSerializer.serialize((EntityReference)reference, new Object[0]);
        MetaData extraMeta = new MetaData();
        extraMeta.addMetaData("source", (Object)source);
        extraMeta.addMetaData("base", (Object)source);
        MetaDataBlock metadataContent = new MetaDataBlock(Collections.singletonList(panel), extraMeta);
        return Collections.singletonList(metadataContent);
    }

    private String renderExcerptContent(XDOM displayContent) {
        try {
            XWikiDocument docForRendering = new XWikiDocument(null);
            docForRendering.setContent(displayContent);
            return docForRendering.getContent();
        }
        catch (XWikiException e) {
            return "{{error}}\n" + this.localizationManager.getTranslationPlain("rendering.macro.excerptinclude.renderfailure", new Object[0]) + "\n{{/error}}";
        }
    }

    private XDOM getExcerpt(String name, XWikiDocument document, MacroTransformationContext context, boolean inline) throws MacroExecutionException {
        DocumentDisplayerParameters displayParameters = new DocumentDisplayerParameters();
        displayParameters.setContentTransformed(true);
        displayParameters.setExecutionContextIsolated(true);
        displayParameters.setTransformationContextIsolated(true);
        XDOM displayContent = this.getExcerptFromXDOM(name, document.getXDOM(), document, displayParameters, inline);
        if (displayContent == null) {
            if (StringUtils.isEmpty((CharSequence)name)) {
                this.checkAccess(document.getDocumentReference(), (XWikiContext)this.contextProvider.get());
                displayContent = this.contentDisplayer.display((Object)document, (Object)displayParameters);
            } else {
                displayContent = this.getErrorXDOM(this.localizationManager.getTranslationPlain("rendering.macro.excerptinclude.namedexcerptnotfound", new Object[]{name, document.getDocumentReference()}), context);
            }
        }
        if (inline) {
            ClassBlockMatcher matcher = new ClassBlockMatcher(ParagraphBlock.class);
            for (Block p : displayContent.getBlocks((BlockMatcher)matcher, Block.Axes.DESCENDANT_OR_SELF)) {
                p.getParent().replaceChild(p.getChildren(), p);
            }
        }
        return displayContent;
    }

    private XDOM getExcerptFromXDOM(String name, XDOM xdom, XWikiDocument document, DocumentDisplayerParameters displayParameters, boolean inline) throws MacroExecutionException {
        List blocks = xdom.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroBlock.class), Block.Axes.DESCENDANT);
        for (Block block : blocks) {
            XDOM displayContent;
            MacroBlock macroBlock = (MacroBlock)block;
            String candidateName = macroBlock.getParameter(NAME);
            if (candidateName == null) {
                candidateName = "";
            }
            if ((displayContent = "excerpt".equals(macroBlock.getId()) && StringUtils.equals((CharSequence)candidateName, (CharSequence)name) ? this.parseMatchingExcerpt(document, displayParameters, inline, macroBlock) : this.findMatchingExcerpt(name, document, displayParameters, inline, macroBlock)) == null) continue;
            return displayContent;
        }
        return null;
    }

    private XDOM findMatchingExcerpt(String name, XWikiDocument document, DocumentDisplayerParameters displayParameters, boolean inline, MacroBlock macroBlock) throws MacroExecutionException {
        MacroId macroId = new MacroId(macroBlock.getId(), document.getSyntax());
        try {
            DefaultParameterizedType wikiContentType = new DefaultParameterizedType(null, List.class, new Type[]{Block.class});
            ContentDescriptor contentDescriptor = this.macroManager.getMacro(macroId).getDescriptor().getContentDescriptor();
            if (contentDescriptor != null && wikiContentType.equals(contentDescriptor.getType())) {
                ComponentManager cm = (ComponentManager)this.cmProvider.get();
                Parser macroContentParser = (Parser)cm.getInstance(Parser.class, document.getSyntax().toIdString());
                XDOM macroContent = macroContentParser.parse((Reader)new StringReader(macroBlock.getContent()));
                return this.getExcerptFromXDOM(name, macroContent, document, displayParameters, inline);
            }
        }
        catch (NullPointerException | MacroLookupException e) {
            this.logger.debug("No macro found for [{}]", (Object)macroId, (Object)e);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to find required component to find excerpt in [{}]", (Object)document.getDocumentReference());
            this.logger.debug("It is missing because:", (Throwable)e);
        }
        catch (ParseException e) {
            this.logger.info("Failed to parse content of wiki macro [{}] in document [{}] to look for excerpt", (Object)macroBlock.getId(), (Object)document.getDocumentReference());
            this.logger.debug("Reason:", (Throwable)e);
        }
        return null;
    }

    private XDOM parseMatchingExcerpt(XWikiDocument document, DocumentDisplayerParameters displayParameters, boolean inline, MacroBlock macroBlock) throws MacroExecutionException {
        boolean allowUnprivileged;
        String unprivileged = macroBlock.getParameter("allowUnprivilegedInclude");
        boolean bl = allowUnprivileged = "1".equals(unprivileged) || "true".equalsIgnoreCase(unprivileged);
        if (!allowUnprivileged) {
            this.checkAccess(document.getDocumentReference(), (XWikiContext)this.contextProvider.get());
        }
        XWikiDocument documentClone = document.clone();
        try {
            MacroBlock mb = macroBlock;
            mb.setParameter("hidden", "false");
            if (inline && !mb.isInline()) {
                mb = new MacroBlock(macroBlock.getId(), mb.getParameters(), mb.getContent(), true);
            }
            documentClone.setContent(new XDOM(Collections.singletonList(mb)));
        }
        catch (XWikiException e) {
            throw new MacroExecutionException("Could not include the excerpt", (Throwable)e);
        }
        XDOM displayContent = this.contentDisplayer.display((Object)documentClone, (Object)displayParameters);
        return displayContent;
    }

    private XDOM getErrorXDOM(String message, MacroTransformationContext context) {
        return new XDOM(Collections.singletonList(new MacroBlock("error", Collections.emptyMap(), message, context.isInline())));
    }

    private void checkAccess(DocumentReference reference, XWikiContext xcontext) throws MacroExecutionException {
        if (!this.contextualAuthorization.hasAccess(Right.VIEW, (EntityReference)reference)) {
            throw new MacroExecutionException(String.format("Current user [%s] doesn't have view rights on document [%s]", xcontext.getUserReference(), reference));
        }
    }
}

