/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.macros;

import com.xwiki.licensing.Licensor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.extension.ExtensionId;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.stability.Unstable;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Unstable
public abstract class AbstractProMacro<P>
extends AbstractMacro<P> {
    private static final ExtensionId PRO_MACROS_EXT_ID = new ExtensionId("com.xwiki.pro:xwiki-pro-macros");
    private static final LocalDocumentReference APP_WEBHOME = new LocalDocumentReference(Arrays.asList("Confluence", "Macros"), "WebHome");
    private static final Set<String> DEFAULT_CATEGORIES = Collections.singleton("Content");
    @Inject
    private Licensor licensor;
    @Inject
    private DocumentAccessBridge accessBridge;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    protected AbstractProMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        super(name, description, contentDescriptor, parametersBeanClass);
        this.setDefaultCategories(DEFAULT_CATEGORIES);
    }

    protected AbstractProMacro(String name, String description, Class<?> parametersBeanClass) {
        super(name, description, parametersBeanClass);
        this.setDefaultCategories(DEFAULT_CATEGORIES);
    }

    public List<Block> execute(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (this.licensor.hasLicensure(PRO_MACROS_EXT_ID) || this.licensor.hasLicensure((EntityReference)new DocumentReference(APP_WEBHOME, new WikiReference(this.wikiDescriptorManager.getCurrentWikiId())))) {
            return this.internalExecute(parameters, content, context);
        }
        return Collections.singletonList(new MacroBlock("missingLicenseMessage", Collections.singletonMap("extensionName", "proMacros.extension.name"), null, context.isInline()));
    }

    protected abstract List<Block> internalExecute(P var1, String var2, MacroTransformationContext var3) throws MacroExecutionException;

    public WikiDescriptorManager getWikiDescriptorManager() {
        return this.wikiDescriptorManager;
    }
}

